/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.serializer.ColorSerializer;
import com.twosigma.beakerx.jvm.serialization.DateSerializer;
import com.twosigma.beakerx.table.ColumnType;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.table.TableDisplayAlignmentProvider;
import com.twosigma.beakerx.table.format.DecimalStringFormat;
import com.twosigma.beakerx.table.format.TableDisplayStringFormat;
import com.twosigma.beakerx.table.format.TimeStringFormat;
import com.twosigma.beakerx.table.format.ValueStringFormat;
import com.twosigma.beakerx.table.highlight.HeatmapHighlighter;
import com.twosigma.beakerx.table.highlight.TableDisplayCellHighlighter;
import com.twosigma.beakerx.table.highlight.ThreeColorHeatmapHighlighter;
import com.twosigma.beakerx.table.highlight.UniqueEntriesHighlighter;
import com.twosigma.beakerx.table.highlight.ValueHighlighter;
import com.twosigma.beakerx.table.renderer.DataBarsRenderer;
import com.twosigma.beakerx.table.renderer.TableDisplayCellRenderer;
import com.twosigma.beakerx.table.serializer.DataBarsRendererSerializer;
import com.twosigma.beakerx.table.serializer.DecimalStringFormatSerializer;
import com.twosigma.beakerx.table.serializer.HeatmapHighlighterSerializer;
import com.twosigma.beakerx.table.serializer.TableDisplaySerializer;
import com.twosigma.beakerx.table.serializer.ThreeColorHeatmapHighlighterSerializer;
import com.twosigma.beakerx.table.serializer.TimeStringFormatSerializer;
import com.twosigma.beakerx.table.serializer.UniqueEntriesHighlighterSerializer;
import com.twosigma.beakerx.table.serializer.ValueHighlighterSerializer;
import com.twosigma.beakerx.table.serializer.ValueStringFormatSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TableDisplayToJson {
    private static ObjectMapper mapper;

    public static SimpleModule tableDisplayModule() {
        SimpleModule module = new SimpleModule("TableDisplaySerializer", new Version(1, 0, 0, null));
        module.addSerializer(TableDisplay.class, (JsonSerializer)new TableDisplaySerializer());
        module.addSerializer(ValueStringFormat.class, (JsonSerializer)new ValueStringFormatSerializer());
        module.addSerializer(DecimalStringFormat.class, (JsonSerializer)new DecimalStringFormatSerializer());
        module.addSerializer(TimeStringFormat.class, (JsonSerializer)new TimeStringFormatSerializer());
        module.addSerializer(DataBarsRenderer.class, (JsonSerializer)new DataBarsRendererSerializer());
        module.addSerializer(HeatmapHighlighter.class, new HeatmapHighlighterSerializer());
        module.addSerializer(ThreeColorHeatmapHighlighter.class, (JsonSerializer)new ThreeColorHeatmapHighlighterSerializer());
        module.addSerializer(UniqueEntriesHighlighter.class, (JsonSerializer)new UniqueEntriesHighlighterSerializer());
        module.addSerializer(ValueHighlighter.class, (JsonSerializer)new ValueHighlighterSerializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        module.addSerializer(Color.class, (JsonSerializer)new ColorSerializer());
        return module;
    }

    public static Map toJson(Object item) {
        return (Map)mapper.convertValue(item, Map.class);
    }

    public static List toJsonList(Object item) {
        return (List)mapper.convertValue(item, List.class);
    }

    static Map<Object, Object> serializeStringFormatForTimes(TimeUnit stringFormatForTimes) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("stringFormatForTimes", (Object)stringFormatForTimes);
        return value;
    }

    static Map<Object, Object> serializeStringFormatForType(Map<ColumnType, TableDisplayStringFormat> stringFormatForType) {
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        for (Map.Entry<ColumnType, TableDisplayStringFormat> pair : stringFormatForType.entrySet()) {
            result.put(pair.getKey().getType(), TableDisplayToJson.toJson(pair.getValue()));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("stringFormatForType", result);
        return value;
    }

    static Map<Object, Object> serializeAlignmentForColumn(Map<String, TableDisplayAlignmentProvider> alignmentForColumn) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, TableDisplayAlignmentProvider> pair : alignmentForColumn.entrySet()) {
            result.put(pair.getKey(), pair.getValue().toString());
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("alignmentForColumn", result);
        return value;
    }

    static Map<Object, Object> serializeStringFormatForColumn(Map<String, TableDisplayStringFormat> stringFormatForColumn) {
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        for (Map.Entry<String, TableDisplayStringFormat> pair : stringFormatForColumn.entrySet()) {
            result.put(pair.getKey(), TableDisplayToJson.toJson(pair.getValue()));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("stringFormatForColumn", result);
        return value;
    }

    static Map<Object, Object> serializeRendererForType(Map<ColumnType, TableDisplayCellRenderer> rendererForType) {
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        for (Map.Entry<ColumnType, TableDisplayCellRenderer> pair : rendererForType.entrySet()) {
            result.put(pair.getKey().getType(), TableDisplayToJson.toJson(pair.getValue()));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("rendererForType", result);
        return value;
    }

    static Map<Object, Object> serializeRendererForColumn(Map<String, TableDisplayCellRenderer> rendererMap) {
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        for (Map.Entry<String, TableDisplayCellRenderer> pair : rendererMap.entrySet()) {
            result.put(pair.getKey(), TableDisplayToJson.toJson(pair.getValue()));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("rendererForColumn", result);
        return value;
    }

    static Map<Object, Object> serializeAlignmentForType(Map<ColumnType, TableDisplayAlignmentProvider> map) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<ColumnType, TableDisplayAlignmentProvider> pair : map.entrySet()) {
            result.put(pair.getKey().toString(), pair.getValue().toString());
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("alignmentForType", result);
        return value;
    }

    static Map<Object, Object> serializeColumnsFrozen(Map<String, Boolean> map) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> pair : map.entrySet()) {
            result.put(pair.getKey(), pair.getValue());
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("columnsFrozen", result);
        return value;
    }

    static Map<Object, Object> serializeColumnsFrozenRight(Map<String, Boolean> map) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> pair : map.entrySet()) {
            result.put(pair.getKey(), pair.getValue());
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("columnsFrozenRight", result);
        return value;
    }

    static Map<Object, Object> serializeColumnsVisible(Map<String, Boolean> map) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> pair : map.entrySet()) {
            result.put(pair.getKey(), pair.getValue());
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("columnsVisible", result);
        return value;
    }

    static Map<Object, Object> serializeCellHighlighters(List<TableDisplayCellHighlighter> list) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (TableDisplayCellHighlighter item : list) {
            result.add(TableDisplayToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("cellHighlighters", result);
        return value;
    }

    static Map<Object, Object> serializeColumnOrder(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : list) {
            result.add(item);
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("columnOrder", result);
        return value;
    }

    static Map<Object, Object> serializeTooltips(List<List<String>> list) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("tooltips", TableDisplayToJson.toJsonList(list));
        return value;
    }

    static Map<Object, Object> serializeDataFontSize(Integer dataFontSize) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("dataFontSize", dataFontSize);
        return value;
    }

    static Map<Object, Object> serializeHeaderFontSize(Integer headerFontSize) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("headerFontSize", headerFontSize);
        return value;
    }

    static Map<Object, Object> serializeFontColor(List<List<Color>> list) {
        ArrayList result = new ArrayList();
        list.forEach(item -> {
            ArrayList elements = new ArrayList();
            item.forEach(x -> elements.add(mapper.convertValue(x, String.class)));
            result.add(elements);
        });
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("fontColor", result);
        return value;
    }

    static Map<Object, Object> serializeFilteredValues(List<List<?>> list) {
        ArrayList result = new ArrayList();
        list.forEach(item -> {
            ArrayList elements = new ArrayList();
            item.forEach(x -> elements.add(mapper.convertValue(x, String.class)));
            result.add(elements);
        });
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("filteredValues", result);
        return value;
    }

    static Map<Object, Object> serializeHeadersVertical(boolean headersVertical) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("headersVertical", headersVertical);
        return value;
    }

    static Map<Object, Object> serializeHasIndex(String hasIndex) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("hasIndex", hasIndex);
        return value;
    }

    static Map<Object, Object> serializeTimeZone(String timeZone) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("timeZone", timeZone);
        return value;
    }

    static Map<Object, Object> serializeDoubleClickAction(String doubleClickTag, boolean hasDoubleClickAction) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("hasDoubleClickAction", hasDoubleClickAction);
        value.put("doubleClickTag", doubleClickTag);
        return value;
    }

    static {
        SimpleModule module = TableDisplayToJson.tableDisplayModule();
        mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.registerModule((Module)module);
    }
}

