/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widgets;

import com.twosigma.beakerx.SerializeToString;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widgets.CommFunctionality;
import com.twosigma.beakerx.widgets.DisplayableWidget;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Widget
implements CommFunctionality,
DisplayableWidget {
    private static final Logger logger = LoggerFactory.getLogger(Widget.class);
    public static final String APPLICATION_VND_JUPYTER_WIDGET_VIEW_JSON = "application/vnd.jupyter.widget-view+json";
    public static final String MODEL_ID = "model_id";
    public static final String MODEL_MODULE = "_model_module";
    public static final String MODEL_NAME = "_model_name";
    public static final String VIEW_MODULE = "_view_module";
    public static final String VIEW_NAME = "_view_name";
    public static final String MODEL_MODULE_VALUE = "jupyter-js-widgets";
    public static final String VIEW_MODULE_VALUE = "jupyter-js-widgets";
    public static final String VALUE = "value";
    public static final String DISABLED = "disabled";
    public static final String VISIBLE = "visible";
    public static final String DESCRIPTION = "description";
    public static final String MSG_THROTTLE = "msg_throttle";
    public static final String METHOD = "method";
    public static final String DISPLAY = "display_data";
    private Comm comm = new Comm(TargetNamesEnum.JUPYTER_WIDGET);

    protected void openComm() {
        this.comm.setData(this.createContent());
        this.addValueChangeMsgCallback();
        this.comm.open();
    }

    @Override
    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    @Override
    public void display() {
        this.sendDisplay();
    }

    private void sendDisplay() {
        HashMap<String, Object> content = new HashMap<String, Object>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("version_major", "2");
        data.put("version_minor", "0");
        data.put(MODEL_ID, this.getComm().getCommId());
        content.put(METHOD, DISPLAY);
        content.put(APPLICATION_VND_JUPYTER_WIDGET_VIEW_JSON, data);
        this.getComm().setData(content);
        this.getComm().setMsgType(DISPLAY);
        this.getComm().send(JupyterMessages.DISPLAY_DATA);
    }

    private HashMap<String, Serializable> createContent() {
        String vnv;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(MODEL_MODULE, (Serializable)((Object)this.getModelModuleValue()));
        result.put(VIEW_MODULE, (Serializable)((Object)this.getViewModuleValue()));
        String mn = this.getModelNameValue();
        if (mn != null && !mn.isEmpty()) {
            result.put(MODEL_NAME, (Serializable)((Object)mn));
        }
        if ((vnv = this.getViewNameValue()) != null && !vnv.isEmpty()) {
            result.put(VIEW_NAME, (Serializable)((Object)vnv));
        }
        result = this.content(result);
        return result;
    }

    public abstract String getModelNameValue();

    public abstract String getViewNameValue();

    public String getModelModuleValue() {
        return "jupyter-js-widgets";
    }

    public String getViewModuleValue() {
        return "jupyter-js-widgets";
    }

    protected abstract void addValueChangeMsgCallback();

    protected abstract HashMap<String, Serializable> content(HashMap<String, Serializable> var1);

    @Override
    public Comm getComm() {
        return this.comm;
    }

    public void sendUpdate(String propertyName, Object value) {
        this.comm.sendUpdate(propertyName, value);
    }

    public void handleCommEventSync(Message message, CommActions action, ActionPerformed handlerAction) {
        KernelHandlerWrapper.wrapBusyIdle(KernelManager.get(), message, () -> this.handleCommEvent(message, action, handlerAction));
    }

    private void handleCommEvent(Message message, CommActions action, ActionPerformed handlerAction) {
        Object contentObject;
        Serializable data;
        if (message.getContent() != null && (data = message.getContent().get("data")) != null && data instanceof LinkedHashMap && (contentObject = ((LinkedHashMap)data).get("content")) instanceof LinkedHashMap) {
            LinkedHashMap content = (LinkedHashMap)contentObject;
            if (handlerAction != null) {
                handlerAction.executeAction(content, message);
            }
        }
    }

    public void handleCompiledCode(Message message, boolean publishResult, ExecuteCompiledCode handler, Object ... params) {
        MessageCreator mc = new MessageCreator(KernelManager.get());
        SimpleEvaluationObject seo = new SimpleEvaluationObject("", seoResult -> {});
        if (message != null) {
            seo.setJupyterMessage(message);
            seo.setOutputHandler();
            seo.addObserver(KernelManager.get().getExecutionResultSender());
            InternalVariable.setValue(seo);
            KernelManager.get().publish(mc.buildClearOutput(message, true));
        }
        try {
            Object result = handler.executeCode(params);
            if (result != null && message != null) {
                List<MIMEContainer> resultString = SerializeToString.doit(result);
                if (publishResult) {
                    KernelManager.get().publish(mc.buildDisplayData(message, resultString));
                }
            }
        }
        catch (Exception e) {
            if (message != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                seo.error(sw.toString());
            }
            logger.info("Execution result ERROR: \n" + e);
        }
        seo.clrOutputHandler();
    }

    public void activateWidgetInContainer() {
    }

    public static interface ExecuteCompiledCode {
        public Object executeCode(Object ... var1) throws Exception;
    }

    public static interface ActionPerformed {
        public void executeAction(HashMap var1, Message var2);
    }

    public static enum CommActions {
        DOUBLE_CLICK("DOUBLE_CLICK"),
        ONCLICK("onclick"),
        ONKEY("onkey"),
        ACTIONDETAILS("actiondetails"),
        CONTEXT_MENU_CLICK("CONTEXT_MENU_CLICK"),
        CLICK("click");

        private String action;

        private CommActions(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        public static CommActions getByAction(String input) {
            CommActions ret = null;
            if (input != null) {
                for (CommActions item : CommActions.values()) {
                    if (!item.getAction().equalsIgnoreCase(input.trim())) continue;
                    ret = item;
                    break;
                }
            }
            return ret;
        }
    }
}

