/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommMsgHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommMsgHandler.class);
    private MessageCreator messageCreator;

    public CommMsgHandler(KernelFunctionality kernel, MessageCreator messageCreator) {
        super(kernel);
        this.messageCreator = messageCreator;
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        Map<String, Serializable> commMap = message.getContent();
        Comm comm = this.kernel.getComm(CommMsgHandler.getString(commMap, "comm_id"));
        logger.debug("Comm message handling, target name: " + (comm != null ? comm.getTargetName() : "undefined"));
        if (comm != null) {
            comm.handleMsg(message);
        }
    }

    public static String getString(Map<String, Serializable> map, String name) {
        String ret = null;
        if (map != null && name != null && map.containsKey(name)) {
            ret = (String)((Object)map.get(name));
        }
        return ret;
    }
}

