/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.commands;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;

public class ClasspathAddMvnCommand {
    private String pathToCache;
    private String pathToTempRepo;

    public ClasspathAddMvnCommand(String pathToCache, String pathToTempRepo) {
        this.pathToCache = (String)Preconditions.checkNotNull((Object)pathToCache);
        this.pathToTempRepo = (String)Preconditions.checkNotNull((Object)pathToTempRepo);
    }

    public AddMvnCommandResult retrieve(String groupId, String artifactId, String version) {
        try {
            IBiblioResolver br = this.createBiblioResolver();
            IvySettings ivySettings = this.createIvyInstance(this.pathToCache, br);
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ResolveOptions resolveOptions = this.createResolveOptions();
            ModuleDescriptor moduleDescriptor = this.getModuleDescriptor(groupId, artifactId, version, ivy, resolveOptions);
            String absolutePath = new File(this.pathToTempRepo).getAbsolutePath();
            ivy.retrieve(moduleDescriptor.getModuleRevisionId(), absolutePath + "/[artifact](-[classifier]).[ext]", new RetrieveOptions().setConfs(new String[]{"default"}));
            return AddMvnCommandResult.SUCCESS;
        }
        catch (Exception e) {
            return AddMvnCommandResult.error(e.getMessage());
        }
    }

    private ModuleDescriptor getModuleDescriptor(String groupId, String artifactId, String version, Ivy ivy, ResolveOptions ro) {
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)groupId, (String)(artifactId + "-envelope"), (String)version));
        ModuleRevisionId ri = ModuleRevisionId.newInstance((String)groupId, (String)artifactId, (String)version);
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)md, ri, false, false, true);
        dd.addDependencyConfiguration("default", "default");
        md.addDependency((DependencyDescriptor)dd);
        ResolveReport rr = this.getResolveReport(ivy, ro, md);
        return rr.getModuleDescriptor();
    }

    private ResolveReport getResolveReport(Ivy ivy, ResolveOptions ro, DefaultModuleDescriptor md) {
        ResolveReport rr = null;
        try {
            rr = ivy.resolve((ModuleDescriptor)md, ro);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (rr.hasError()) {
            throw new RuntimeException(rr.getAllProblemMessages().toString());
        }
        return rr;
    }

    private ResolveOptions createResolveOptions() {
        ResolveOptions ro = new ResolveOptions();
        ro.setLog("quiet");
        ro.setTransitive(true);
        ro.setDownload(true);
        return ro;
    }

    private IBiblioResolver createBiblioResolver() {
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        br.setName("central");
        return br;
    }

    private IvySettings createIvyInstance(String pathToCache, IBiblioResolver br) {
        IvySettings ivySettings = new IvySettings();
        ivySettings.setDefaultCache(new File(pathToCache));
        ivySettings.addResolver((DependencyResolver)br);
        ivySettings.setDefaultResolver(br.getName());
        return ivySettings;
    }

    public static class AddMvnCommandResult {
        public static final AddMvnCommandResult SUCCESS = new AddMvnCommandResult(true, "");
        private boolean jarRetrieved;
        private String errorMessage;

        private AddMvnCommandResult(boolean retrieved, String errorMessage) {
            this.jarRetrieved = retrieved;
            this.errorMessage = errorMessage;
        }

        public boolean isJarRetrieved() {
            return this.jarRetrieved;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static AddMvnCommandResult success() {
            return SUCCESS;
        }

        public static AddMvnCommandResult error(String msg) {
            return new AddMvnCommandResult(false, msg);
        }
    }
}

