/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.kotlin.evaluator.KotlinCodeRunner;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;

class KotlinWorkerThread
extends WorkerThread {
    private static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private KotlinEvaluator kotlinEvaluator;
    protected boolean exit;
    protected boolean updateLoader;

    public KotlinWorkerThread(KotlinEvaluator kotlinEvaluator) {
        super("kotlin worker");
        this.kotlinEvaluator = kotlinEvaluator;
        this.exit = false;
        this.updateLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicClassLoaderSimple loader = null;
        JobDescriptor j = null;
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                if (loader == null || this.updateLoader) {
                    loader = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
                    loader.addJars(this.kotlinEvaluator.getClasspath().getPathsAsStrings());
                    loader.addDynamicDir(this.kotlinEvaluator.getOutDir());
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                nc = NamespaceClient.getBeaker((String)this.kotlinEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                j.outputObject.started();
                String classpath = System.getProperty("java.class.path");
                String[] classpathEntries = classpath.split(File.pathSeparator);
                LineBrakingStringBuilderWrapper javaSourceCode = new LineBrakingStringBuilderWrapper();
                javaSourceCode.append("package ");
                javaSourceCode.append(this.kotlinEvaluator.getPackageId());
                javaSourceCode.append("\n\n");
                for (ImportPath i : this.kotlinEvaluator.getImports().getImportPaths()) {
                    javaSourceCode.append("import ");
                    javaSourceCode.append(this.adjustImport(i));
                    javaSourceCode.append("\n");
                }
                javaSourceCode.append("\n");
                javaSourceCode.append("class BeakerWrapperClass1261714175 {\n");
                javaSourceCode.append("fun beakerRun() {\n");
                javaSourceCode.append(j.codeToBeExecuted);
                javaSourceCode.append("\n}\n");
                javaSourceCode.append("}\n");
                K2JVMCompiler comp = new K2JVMCompiler();
                ExitCode exitCode = null;
                ByteArrayOutputStream errorBaos = new ByteArrayOutputStream();
                PrintStream errorPs = new PrintStream(errorBaos);
                Path sourceFile = Files.write(Paths.get(this.kotlinEvaluator.getOutDir() + "\\" + WRAPPER_CLASS_NAME + ".kt", new String[0]), javaSourceCode.toString().getBytes(), new OpenOption[0]);
                K2JVMCompilerArguments arguments = K2JVMCompilerArguments.createDefaultInstance();
                arguments.includeRuntime = true;
                arguments.destination = this.kotlinEvaluator.getOutDir();
                arguments.classpath = this.getEntriesAsString(classpathEntries, Kernel.isWindows() ? ";" : ":");
                arguments.verbose = false;
                arguments.suppressWarnings = true;
                arguments.noStdlib = true;
                arguments.coroutinesState = "error";
                arguments.freeArgs = new ArrayList();
                arguments.freeArgs.add(sourceFile.toString());
                arguments.skipRuntimeVersionCheck = true;
                PrintingMessageCollector collector = new PrintingMessageCollector(errorPs, MessageRenderer.PLAIN_RELATIVE_PATHS, arguments.verbose);
                exitCode = comp.exec((MessageCollector)collector, Services.EMPTY, (CommonCompilerArguments)arguments);
                if (ExitCode.COMPILATION_ERROR == exitCode) {
                    j.outputObject.error((Object)new String(errorBaos.toByteArray(), StandardCharsets.UTF_8));
                    j.outputObject.executeCodeCallback();
                } else if (ExitCode.OK == exitCode) {
                    try {
                        Class fooClass = loader.loadClass(this.kotlinEvaluator.getPackageId() + "." + WRAPPER_CLASS_NAME);
                        Method mth = fooClass.getDeclaredMethod("beakerRun", null);
                        if (!this.kotlinEvaluator.executeTask(new KotlinCodeRunner(fooClass.newInstance(), mth, j.outputObject, false, (ClassLoader)loader))) {
                            j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                        }
                        if (nc != null) {
                            nc.setOutputObj(null);
                            nc = null;
                        }
                    }
                    catch (Exception e) {
                        j.outputObject.error((Object)e);
                    }
                }
                j = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.kotlinEvaluator.getSessionId());
    }

    private String adjustImport(ImportPath importPath) {
        String currentImportPath = importPath.asString();
        if (currentImportPath.startsWith("import")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.startsWith("static")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.contains(".object.")) {
            currentImportPath = currentImportPath.replace(".object.", ".`object`.");
        }
        return currentImportPath;
    }

    public String getEntriesAsString(String[] classpathEntries, String separator) {
        String ret = "";
        for (String string : classpathEntries) {
            ret = ret + string + separator;
        }
        return ret;
    }

    public void updateLoader() {
        this.updateLoader = true;
    }

    public void doExit() {
        this.exit = true;
        this.removeKtFile();
    }

    private void removeKtFile() {
        try {
            Files.deleteIfExists(new File(this.kotlinEvaluator.getOutDir() + "\\" + WRAPPER_CLASS_NAME + ".kt").toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LineBrakingStringBuilderWrapper {
        private static final String LINE_BREAK = "\n";
        private StringBuilder delegate = new StringBuilder();
        private int linesCount = 0;

        public void append(String string) {
            this.delegate.append(string);
            this.linesCount += StringUtils.countMatches((CharSequence)string, (CharSequence)LINE_BREAK);
        }

        public int getLinesCount() {
            return this.linesCount;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

