/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommCloseHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommCloseHandler.class);

    public CommCloseHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public static String getString(Map<String, Serializable> map, String name) {
        String ret = null;
        if (map != null && name != null && map.containsKey(name)) {
            ret = (String)((Object)map.get(name));
        }
        return ret;
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing CommCloseHandler");
        Map<String, Serializable> commMap = message.getContent();
        String targetName = this.kernel.getComm(CommCloseHandler.getString(commMap, "comm_id")) != null ? this.kernel.getComm(CommCloseHandler.getString(commMap, "comm_id")).getTargetName() : "";
        this.kernel.removeComm(CommCloseHandler.getString(commMap, "comm_id"));
        Message reply = new Message();
        reply.setHeader(new Header(JupyterMessages.COMM_CLOSE, message.getHeader().getSession()));
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("data", new HashMap());
        reply.setContent(map);
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
        logger.debug("Comm closed, target name = " + targetName);
    }
}

