/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelParameters;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.message.Message;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluatorManager {
    public static Logger logger = LoggerFactory.getLogger(EvaluatorManager.class);
    protected Evaluator evaluator = null;
    protected KernelFunctionality kernel;

    public EvaluatorManager(KernelFunctionality kernel, Evaluator evaluator) {
        this.kernel = kernel;
        this.evaluator = evaluator;
    }

    public void initKernel(KernelParameters kernelParameters) {
        this.evaluator.initKernel(kernelParameters);
    }

    public synchronized void setShellOptions(KernelParameters kernelParameters) {
        try {
            this.evaluator.setShellOptions(kernelParameters);
        }
        catch (IOException e) {
            logger.error("Error while setting Shell Options", (Throwable)e);
        }
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.evaluator.autocomplete(code, caretPosition);
    }

    public void cancelExecution() {
        this.evaluator.cancelExecution();
    }

    public synchronized void killAllThreads() {
        this.evaluator.killAllThreads();
    }

    public synchronized SimpleEvaluationObject executeCode(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        return this.execute(code, message, executionCount, executeCodeCallback);
    }

    public void exit() {
        this.evaluator.exit();
    }

    private SimpleEvaluationObject execute(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        SimpleEvaluationObject seo = this.createSimpleEvaluationObject(code, message, executionCount, executeCodeCallback);
        this.evaluator.evaluate(seo, code);
        return seo;
    }

    private SimpleEvaluationObject createSimpleEvaluationObject(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject(code, executeCodeCallback);
        seo.setJupyterMessage(message);
        seo.setExecutionCount(executionCount);
        seo.addObserver(this.kernel.getExecutionResultSender());
        return seo;
    }

    public boolean addJarToClasspath(PathToJar path) {
        return this.evaluator.addJarToClasspath(path);
    }

    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        return this.evaluator.addJarsToClasspath(paths);
    }

    public Classpath getClasspath() {
        return this.evaluator.getClasspath();
    }

    public Imports getImports() {
        return this.evaluator.getImports();
    }

    public void addImport(ImportPath anImport) {
        this.evaluator.addImport(anImport);
    }

    public void removeImport(ImportPath anImport) {
        this.evaluator.removeImport(anImport);
    }

    public Path getTempFolder() {
        return this.evaluator.getTempFolder();
    }
}

