/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAutocomplete;
import com.twosigma.beakerx.groovy.autocomplete.GroovyClasspathScanner;
import com.twosigma.beakerx.groovy.evaluator.EnvVariablesFilter;
import com.twosigma.beakerx.groovy.evaluator.GroovyClassLoaderFactory;
import com.twosigma.beakerx.groovy.evaluator.GroovyWorkerThread;
import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.concurrent.Executors;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyEvaluator
extends BaseEvaluator {
    private GroovyClasspathScanner cps = new GroovyClasspathScanner();
    private GroovyAutocomplete gac = this.createGroovyAutocomplete(this.cps);
    private GroovyClassLoader groovyClassLoader;
    private Binding scriptBinding = null;
    private ImportCustomizer icz;
    private BeakerXUrlClassLoader beakerxUrlClassLoader;

    public GroovyEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("groovy"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters, beakerxClient);
    }

    public GroovyEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient);
        this.outDir = EnvVariablesFilter.envVariablesFilter(this.outDir, System.getenv());
        this.reloadClassloader();
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code) {
        return this.evaluate(seo, new GroovyWorkerThread(this, new JobDescriptor(code, seo)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.gac.doAutocomplete(code, caretPosition, (ClassLoader)this.groovyClassLoader, this.imports);
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath);
        this.cps = new GroovyClasspathScanner(cpp);
        this.gac = this.createGroovyAutocomplete(this.cps);
        this.reloadClassloader();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void exit() {
        super.exit();
        this.cancelExecution();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.beakerxUrlClassLoader.addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        GroovyClassLoaderFactory.addImportPathToImportCustomizer(this.icz, anImport);
    }

    private GroovyAutocomplete createGroovyAutocomplete(GroovyClasspathScanner c) {
        return new GroovyAutocomplete(c);
    }

    private String createClasspath(Classpath classPath) {
        StringBuilder cppBuilder = new StringBuilder();
        for (String pt : classPath.getPathsAsStrings()) {
            cppBuilder.append(pt);
            cppBuilder.append(File.pathSeparator);
        }
        String cpp = cppBuilder.toString();
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public ClassLoader getClassLoader() {
        return this.groovyClassLoader;
    }

    private void reloadClassloader() {
        this.beakerxUrlClassLoader = GroovyClassLoaderFactory.newParentClassLoader(this.getClasspath());
        this.icz = new ImportCustomizer();
        this.groovyClassLoader = GroovyClassLoaderFactory.newEvaluator(this.getImports(), this.getClasspath(), this.getOutDir(), this.icz, (ClassLoader)this.beakerxUrlClassLoader);
        this.scriptBinding = new Binding();
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    public Binding getScriptBinding() {
        return this.scriptBinding;
    }
}

