/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.groovy.autocomplete.AutocompleteGroovyResult;
import com.twosigma.beakerx.groovy.autocomplete.AutocompleteRegistryFactory;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAbstractListener;
import com.twosigma.beakerx.groovy.autocomplete.GroovyParser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyImportDeclarationCompletion
extends GroovyAbstractListener {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyImportDeclarationCompletion.class.getName());
    private int cursor;
    private String text;
    private AutocompleteRegistry registry;
    private ClasspathScanner cps;
    private ClassUtils classUtils;

    public GroovyImportDeclarationCompletion(String t, int c, AutocompleteRegistry r, ClasspathScanner p, ClassUtils cu) {
        this.cursor = c;
        this.text = t;
        this.registry = r;
        this.cps = p;
        this.classUtils = cu;
    }

    @Override
    public void exitImportStatement(GroovyParser.ImportStatementContext ctx) {
        if (this.isAutocompleteOfImportStatement(ctx)) {
            if (this.text.charAt(this.cursor - 1) == '.') {
                this.importPackageNameAfterDot(ctx);
            } else {
                this.importPackageName(ctx);
            }
        } else {
            String st = ctx.getText();
            if (this.isWildcard(st = this.removeImportWord(st))) {
                this.importWithWildcard(st);
            } else {
                AutocompleteRegistryFactory.createImportAutocompleteCandidate(this.classUtils, this.registry, st);
            }
        }
    }

    private boolean isWildcard(String st) {
        return st.endsWith(".*");
    }

    private boolean isAutocompleteOfImportStatement(GroovyParser.ImportStatementContext ctx) {
        return ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor;
    }

    private String removeImportWord(String st) {
        if (st.startsWith("import")) {
            st = st.substring(6).trim();
        }
        return st;
    }

    private void importPackageNameAfterDot(GroovyParser.ImportStatementContext ctx) {
        String st = ctx.getText();
        st = this.removeImportWord(st);
        String[] txtv = (st + "X").split("\\.");
        txtv[txtv.length - 1] = "";
        AutocompleteCandidate c = new AutocompleteCandidate(0, txtv);
        this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx) + 1);
        c = new AutocompleteCandidate(5, txtv);
        this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx) + 1);
    }

    private void importPackageName(GroovyParser.ImportStatementContext ctx) {
        String st = ctx.getText();
        st = this.removeImportWord(st);
        String[] txtv = st.split("\\.");
        AutocompleteCandidate c = new AutocompleteCandidate(0, txtv);
        this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
        c = new AutocompleteCandidate(5, txtv);
        this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
    }

    private void importWithWildcard(String st) {
        String[] txtv = st.split("\\.");
        AutocompleteCandidate c = new AutocompleteCandidate(0, txtv);
        this.registry.addCandidate(c);
        st = st.substring(0, st.length() - 2);
        List cls = this.cps.getClasses(st);
        if (cls != null) {
            c = new AutocompleteCandidate(5, txtv);
            AutocompleteCandidate l = c.findLeaf();
            for (String s : cls) {
                l.addChildren(new AutocompleteCandidate(6, s));
                this.registry.addCandidate(new AutocompleteCandidate(6, s));
                this.classUtils.defineClassShortName(s, st + "." + s);
            }
            this.registry.addCandidate(c);
        }
    }
}

