/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.kernel;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.BeakerXJsonSerializer;
import com.twosigma.beakerx.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaListOfPrimitiveTypeMapsSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeListOfListSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaTableDeSerializer;
import com.twosigma.beakerx.table.TableDisplayToJson;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class ScalaBeakerXJsonSerializer
implements BeakerXJsonSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BeakerObjectConverter serializer;

    public ScalaBeakerXJsonSerializer() {
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)TableDisplayToJson.tableDisplayModule());
        this.serializer = ScalaBeakerXJsonSerializer.createSerializer();
    }

    public String toJson(Object value) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
            boolean success = this.serializer.writeObject(value, jgen, true);
            jgen.flush();
            sw.flush();
            if (success) {
                return sw.toString();
            }
            return value.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object fromJson(String json) {
        try {
            return this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BeakerObjectConverter createSerializer() {
        BasicObjectSerializer serializer = new BasicObjectSerializer();
        serializer.addfTypeSerializer((ObjectSerializer)new ScalaCollectionSerializer((BeakerObjectConverter)serializer));
        serializer.addfTypeSerializer((ObjectSerializer)new ScalaMapSerializer((BeakerObjectConverter)serializer));
        serializer.addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeListOfListSerializer((BeakerObjectConverter)serializer));
        serializer.addfTypeSerializer((ObjectSerializer)new ScalaListOfPrimitiveTypeMapsSerializer((BeakerObjectConverter)serializer));
        serializer.addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeMapSerializer((BeakerObjectConverter)serializer));
        serializer.addfTypeDeserializer((ObjectDeserializer)new ScalaCollectionDeserializer((BeakerObjectConverter)serializer));
        serializer.addfTypeDeserializer((ObjectDeserializer)new ScalaMapDeserializer((BeakerObjectConverter)serializer));
        serializer.addfTypeDeserializer((ObjectDeserializer)new ScalaTableDeSerializer((BeakerObjectConverter)serializer));
        return serializer;
    }
}

