/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<Language>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create("PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final AtomicBoolean REQUESTS_DRAIN_NEEDED = new AtomicBoolean(true);
    private static final ConcurrentMap<VirtualFile, SubstitutionInfo> ourReparsingRequests = ContainerUtil.newConcurrentMap();

    private LanguageSubstitutors() {
        super("org.jetbrains.kotlin.com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file2, @NotNull Project project) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        for (LanguageSubstitutor substitutor2 : this.forKey(lang)) {
            Language language = substitutor2.getLanguage(file2, project);
            if (language == null) continue;
            LanguageSubstitutors.processLanguageSubstitution(file2, lang, language, project);
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        return language;
    }

    private static void processLanguageSubstitution(@NotNull VirtualFile file2, @NotNull Language originalLang, @NotNull Language substitutedLang, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (originalLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (substitutedLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (file2 instanceof VirtualFileWindow) {
            return;
        }
        Key<Language> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = projectKey.get(file2);
        Language prevLang = ObjectUtils.notNull(prevSubstitutedLang, originalLang);
        if (!prevLang.is(substitutedLang) && file2.replace(projectKey, prevSubstitutedLang, substitutedLang)) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            LanguageSubstitutors.requestReparsing(file2, prevLang, substitutedLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<Language> getOrCreateProjectKey(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        Key<Language> key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
        if (key == null) {
            Key<Key<Language>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set(project, key);
                }
            }
        }
        Key<Language> key3 = key;
        if (key3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        return key3;
    }

    private static void requestReparsing(@NotNull VirtualFile file2, @NotNull Language prevLang, @NotNull Language substitutedLang) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        if (prevLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        if (substitutedLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        ourReparsingRequests.put(file2, new SubstitutionInfo(prevLang, substitutedLang));
        if (REQUESTS_DRAIN_NEEDED.compareAndSet(true, false)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                REQUESTS_DRAIN_NEEDED.set(true);
                ArrayList set = ContainerUtil.newArrayList(ourReparsingRequests.entrySet());
                ArrayList<VirtualFile> files2 = ContainerUtil.newArrayListWithCapacity(set.size());
                int id = 1;
                for (Map.Entry entry : set) {
                    VirtualFile f = (VirtualFile)entry.getKey();
                    SubstitutionInfo info = (SubstitutionInfo)entry.getValue();
                    ourReparsingRequests.remove(f);
                    if (!f.isValid()) continue;
                    LOG.info("Reparsing " + f.getPath() + " because of language substitution " + info.myPrevLang.getID() + "->" + info.mySubstitutedLang.getID() + ", #" + id++);
                    files2.add(f);
                }
                if (files2.size() > 0) {
                    FileContentUtilCore.reparseFiles(files2);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public static void cancelReparsing(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "cancelReparsing"));
        }
        ourReparsingRequests.remove(file2);
    }

    private static class SubstitutionInfo {
        private final Language myPrevLang;
        private final Language mySubstitutedLang;

        public SubstitutionInfo(@NotNull Language prevLang, @NotNull Language substitutedLang) {
            if (prevLang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors$SubstitutionInfo", "<init>"));
            }
            if (substitutedLang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors$SubstitutionInfo", "<init>"));
            }
            this.myPrevLang = prevLang;
            this.mySubstitutedLang = substitutedLang;
        }
    }
}

