/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;
import com.twosigma.beakerx.kernel.ImportPath;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Codev {
    private final String pname;
    Map<Integer, Integer> lineNumbersMapping = new HashMap<Integer, Integer>();
    LineBrakingStringBuilderWrapper javaSourceCode = new LineBrakingStringBuilderWrapper();
    private String[] lines;
    private String code;
    private JavaEvaluator javaEvaluator;
    private int index = 0;

    public Codev(String code, JavaEvaluator javaEvaluator) {
        this.code = code;
        this.lines = code.split("\n");
        this.javaEvaluator = javaEvaluator;
        this.pname = this.configurePackage();
        this.configureImports();
    }

    public CodeLine getNotBlankLine() {
        if (this.index >= this.lines.length) {
            throw new RuntimeException("No more line");
        }
        this.index = this.skipBlankLines(this.index);
        return new CodeLine(this.index, this.lines[this.index]);
    }

    private int skipBlankLines(int ci) {
        while (ci < this.lines.length - 1 && StringUtils.isBlank((CharSequence)this.lines[ci])) {
            ++ci;
        }
        return ci;
    }

    public String getLastLine() {
        return this.lines[this.lines.length - 1];
    }

    public void moveToNextLine() {
        this.index = this.index != -1 && this.index < this.lines.length - 1 ? ++this.index : -1;
    }

    public String getPname() {
        return this.pname;
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasLineToProcess() {
        return this.index != -1;
    }

    private void configureImports() {
        if (this.hasLineToProcess()) {
            Pattern p = Pattern.compile("\\s*import(\\s+static)?\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*(?:\\.\\*)?);.*");
            CodeLine codeLine = this.getNotBlankLine();
            Matcher m = p.matcher(codeLine.getLine());
            while (m.matches()) {
                String impstr = m.group(2);
                String staticModifier = m.group(1);
                this.javaSourceCode.append("import ");
                if (staticModifier != null) {
                    this.javaSourceCode.append("static ");
                }
                this.javaSourceCode.append(impstr);
                this.javaSourceCode.append(";\n");
                this.lineNumbersMapping.put(this.javaSourceCode.getLinesCount(), codeLine.getIndex());
                this.moveToNextLine();
                if (!this.hasLineToProcess()) break;
                codeLine = this.getNotBlankLine();
                m = p.matcher(codeLine.getLine());
            }
        }
    }

    private String configurePackage() {
        String pname = this.javaEvaluator.getPackageId();
        CodeLine codeLine = this.getNotBlankLine();
        Pattern p = Pattern.compile("\\s*package\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*);.*");
        Matcher m = p.matcher(codeLine.getLine());
        if (m.matches()) {
            pname = m.group(1);
            this.lineNumbersMapping.put(1, codeLine.getIndex());
            this.moveToNextLine();
        }
        this.javaSourceCode.append("package ");
        this.javaSourceCode.append(pname);
        this.javaSourceCode.append(";\n");
        for (ImportPath i : this.javaEvaluator.getImports().getImportPaths()) {
            this.javaSourceCode.append("import ");
            this.javaSourceCode.append(i.asString());
            this.javaSourceCode.append(";\n");
        }
        return pname;
    }

    public static class LineBrakingStringBuilderWrapper {
        private static final String LINE_BREAK = "\n";
        private StringBuilder delegate = new StringBuilder();
        private int linesCount = 0;

        public void append(String string) {
            this.delegate.append(string);
            this.linesCount += StringUtils.countMatches((CharSequence)string, (CharSequence)LINE_BREAK);
        }

        public int getLinesCount() {
            return this.linesCount;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class CodeLine {
        private int index;
        private String line;

        public CodeLine(int index, String line) {
            this.index = index;
            this.line = line;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLine() {
            return this.line;
        }
    }
}

