/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql;

import com.twosigma.beakerx.sql.DBConnectionException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient {
    private static final Logger logger = LoggerFactory.getLogger((String)JDBCClient.class.getName());
    private Map<String, BasicDataSource> dsMap = new HashMap<String, BasicDataSource>();
    private Set<Driver> drivers = new HashSet<Driver>();

    public JDBCClient() {
        this.loadDrivers(null);
    }

    public BasicDataSource getDataSource(String uri) throws DBConnectionException {
        JDBCClient jDBCClient = this;
        synchronized (jDBCClient) {
            try {
                BasicDataSource ds = this.dsMap.get(uri);
                if (ds == null) {
                    Driver driver = null;
                    for (Driver test : this.drivers) {
                        if (!test.acceptsURL(uri)) continue;
                        driver = test;
                        break;
                    }
                    if (driver == null) {
                        DriverManager.getDriver(uri);
                    }
                    ds = new BasicDataSource();
                    ds.setDriver(driver);
                    ds.setUrl(uri);
                    this.dsMap.put(uri, ds);
                }
                return ds;
            }
            catch (SQLException e) {
                throw new DBConnectionException(uri, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDrivers(List<String> pathList) {
        JDBCClient jDBCClient = this;
        synchronized (jDBCClient) {
            this.dsMap = new HashMap<String, BasicDataSource>();
            this.drivers = new HashSet<Driver>();
            HashSet<URL> urlSet = new HashSet<URL>();
            String dbDriverString = System.getenv("BEAKER_JDBC_DRIVER_LIST");
            if (dbDriverString != null && !dbDriverString.isEmpty()) {
                String[] dbDriverList;
                for (String s : dbDriverList = dbDriverString.split(File.pathSeparator)) {
                    try {
                        urlSet.add(this.toURL(s));
                    }
                    catch (MalformedURLException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            if (pathList != null) {
                for (String path : pathList) {
                    if ((path = path.trim()).startsWith("--") || path.startsWith("#")) continue;
                    try {
                        urlSet.add(this.toURL(path));
                    }
                    catch (MalformedURLException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            URLClassLoader loader = new URLClassLoader(urlSet.toArray(new URL[urlSet.size()]));
            ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class, loader);
            Iterator<Driver> driversIterator = loadedDrivers.iterator();
            try {
                while (driversIterator.hasNext()) {
                    Driver d = driversIterator.next();
                    this.drivers.add(d);
                }
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
            }
        }
    }

    private URL toURL(String s) throws MalformedURLException {
        s = s.trim();
        URL url = null;
        if (!(s.startsWith("jar:") || s.startsWith("http:") || s.startsWith("https:"))) {
            try {
                url = Paths.get(s, new String[0]).toUri().toURL();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (url == null) {
            url = new URL(s);
        }
        return url;
    }
}

