/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.HTML;
import com.twosigma.beakerx.widget.PropertiesWidget;
import com.twosigma.beakerx.widget.PropertyItem;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SparkConfiguration
extends VBox {
    static final String VIEW_NAME_VALUE = "SparkConfigurationView";
    static final String MODEL_NAME_VALUE = "SparkConfigurationModel";
    private Button add = this.createAddButton();
    private HBox header;
    private PropertiesWidget properties;

    SparkConfiguration(Map<String, String> advancedSettings, String sparkVersion) {
        super(new ArrayList());
        this.header = new HBox(Arrays.asList(this.sparkVersionWidget(sparkVersion), this.add));
        this.addConfiguration(advancedSettings);
    }

    private HTML sparkVersionWidget(String version) {
        HTML html = new HTML();
        String ap = String.format("https://spark.apache.org/docs/%s/configuration.html#available-properties", version);
        html.setValue((Object)("<a target=\"_blank\" href=\"" + ap + "\">Available properties</a>"));
        html.setDomClasses(new ArrayList<String>(Arrays.asList("bx-properties-add-label")));
        return html;
    }

    private List<PropertyItem> createPropertyItems(Map<String, String> advancedSettings) {
        return advancedSettings.entrySet().stream().map(x -> this.createPropertyItem((String)x.getKey(), (String)x.getValue())).collect(Collectors.toList());
    }

    private Button createAddButton() {
        Button add = new Button();
        add.setTooltip("Add property");
        add.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-add", "bx-properties-add-button")));
        add.registerOnClick((content, message) -> this.addProperty());
        return add;
    }

    private void addProperty() {
        PropertyItem propertyItem = this.createPropertyItem(new Text(), new Text());
        this.properties.add(propertyItem);
    }

    private PropertyItem createPropertyItem(String name, String value) {
        Text nameWidget = new Text();
        nameWidget.setValue((Object)name);
        Text valueWidget = new Text();
        valueWidget.setValue((Object)value);
        return this.createPropertyItem(nameWidget, valueWidget);
    }

    private PropertyItem createPropertyItem(Text nameWidget, Text valueWidget) {
        nameWidget.setPlaceholder("name");
        nameWidget.setDomClasses(new ArrayList<String>(Arrays.asList("bx-config-name")));
        valueWidget.setPlaceholder("value");
        Button remove = new Button();
        remove.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        PropertyItem propertyItem = new PropertyItem(nameWidget, valueWidget, remove);
        remove.registerOnClick((content, message) -> this.properties.getWidget().remove((Widget)propertyItem));
        return propertyItem;
    }

    private void addConfiguration(Map<String, String> advancedSettings) {
        List<PropertyItem> propertyItems = this.createPropertyItems(advancedSettings);
        this.properties = new PropertiesWidget(propertyItems);
        VBox configuration = new VBox(Arrays.asList(this.properties.getWidget(), this.header));
        configuration.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-configuration")));
        this.add((Widget)configuration);
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    public List<Configuration> getConfiguration() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST;
        }
        List<PropertyItem> children = this.properties.getItems();
        return children.stream().map(x -> new Configuration(x.getNameAsString(), x.getValueAsString())).collect(Collectors.toList());
    }

    public void setConfiguration(Map<String, String> advancedSettings) {
        this.remove((Widget)this.getChildren().get(0));
        this.addConfiguration(advancedSettings);
    }

    public void setDisabledToAll() {
        this.add.setDisabled((Object)true);
        this.properties.disable();
    }

    public void setEnabledToAll() {
        this.add.setDisabled((Object)false);
        this.properties.enable();
    }

    public static class Configuration {
        private String name;
        private String value;

        public Configuration(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

