/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.CodeCell;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.comm.BaseHandler;
import com.twosigma.beakerx.message.Message;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class GetCodeCellsHandler
extends BaseHandler<Object> {
    private static final String GET_CODE_CELLS = "code_cells";
    private ObjectMapper objectMapper = new ObjectMapper();
    private BeakerObjectConverter objectSerializer = new BasicObjectSerializer();

    public GetCodeCellsHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        try {
            List<CodeCell> cells = this.getBeakerCodeCells(this.getValueFromData(message, this.getHandlerCommand()));
            BeakerXClientManager.get().getMessageQueue("CodeCells").put(cells);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<CodeCell> getBeakerCodeCells(Object value) {
        List<Object> codeCellList = null;
        StringWriter sw = new StringWriter();
        JsonGenerator jgen = null;
        try {
            jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
            this.objectSerializer.writeObject(value, jgen, true);
            jgen.flush();
            sw.flush();
            codeCellList = Arrays.asList((Object[])this.objectMapper.readValue(sw.toString(), CodeCell[].class));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return codeCellList;
    }

    @Override
    public String getHandlerCommand() {
        return GET_CODE_CELLS;
    }
}

