/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.kernel.NoSuchKernelException;
import com.twosigma.beakerx.kernel.PythonEntryPoint;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.codec.binary.Base64;
import py4j.ClientServer;
import py4j.GatewayServer;

public class MagicKernelManager {
    ClientServer clientServer = null;
    private PythonEntryPoint pep = null;
    private Process pythonProcess = null;
    private static String DEFAULT_PORT = "25333";
    private static String DEFAULT_PYTHON_PORT = "25334";
    private static int NO_SUCH_KERNEL_CODE = 2;
    private static String PY4J_INIT_MESSAGE = "Py4j server is running";
    private Integer port = null;
    private Integer pythonPort = null;
    private final String kernelName;
    private String context;

    public MagicKernelManager(String kernelName, String context) {
        this.kernelName = kernelName;
        this.context = context;
    }

    private void initPythonProcess() throws NoSuchKernelException {
        this.exit();
        this.port = MagicKernelManager.findFreePort();
        this.pythonPort = MagicKernelManager.findFreePort();
        try {
            ProcessBuilder pb = new ProcessBuilder(this.getPy4jCommand());
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            this.pythonProcess = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.pythonProcess.getInputStream()));
            while (!PY4J_INIT_MESSAGE.equals(br.readLine()) && this.pythonProcess.isAlive()) {
            }
            if (!this.pythonProcess.isAlive() && this.pythonProcess.exitValue() == NO_SUCH_KERNEL_CODE) {
                throw new NoSuchKernelException(this.kernelName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String[] getPy4jCommand() {
        return new String[]{"beakerx", "py4j_server", "--port", this.port == null ? DEFAULT_PORT : String.valueOf(this.port), "--pyport", this.pythonPort == null ? DEFAULT_PYTHON_PORT : String.valueOf(this.pythonPort), "--kernel", this.kernelName, "--context", Base64.encodeBase64String((byte[])this.context.getBytes(StandardCharsets.UTF_8))};
    }

    public void exit() {
        if (this.pep != null) {
            this.pep.shutdownKernel();
            this.pep = null;
        }
        if (this.clientServer != null) {
            this.clientServer.shutdown();
            this.clientServer = null;
        }
        if (this.pythonProcess != null) {
            this.pythonProcess.destroy();
            this.pythonProcess = null;
        }
    }

    public PythonEntryPoint getPythonEntryPoint() throws NoSuchKernelException {
        if (this.pythonProcess == null || !this.pythonProcess.isAlive() || this.clientServer == null) {
            this.initPythonProcess();
        }
        if (this.pep == null) {
            this.pep = this.initPythonEntryPoint();
        }
        return this.pep;
    }

    private PythonEntryPoint initPythonEntryPoint() {
        if (this.clientServer == null) {
            this.initClientServer();
        }
        return (PythonEntryPoint)this.clientServer.getPythonServerEntryPoint(new Class[]{PythonEntryPoint.class});
    }

    private void initClientServer() {
        this.clientServer = new ClientServer(this.port.intValue(), GatewayServer.defaultAddress(), this.pythonPort.intValue(), GatewayServer.defaultAddress(), 0, 0, ServerSocketFactory.getDefault(), SocketFactory.getDefault(), null);
    }

    private List<Message> getIopubMessages() throws IOException {
        String iopubMsg;
        ArrayList<Message> messages = new ArrayList<Message>();
        while (!(iopubMsg = this.pep.getIopubMsg()).equals("null")) {
            messages.add(this.parseMessage(iopubMsg));
        }
        return messages;
    }

    private Message parseMessage(String stringJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(stringJson);
        Message msg = new Message((Header)mapper.convertValue((Object)json.get("header"), Header.class));
        msg.setContent((Map)mapper.convertValue((Object)json.get("content"), Map.class));
        msg.setMetadata((Map)mapper.convertValue((Object)json.get("metadata"), Map.class));
        msg.setBuffers((List)mapper.convertValue((Object)json.get("buffers"), List.class));
        List identities = (List)mapper.convertValue((Object)json.get("comm_id"), List.class);
        msg.setIdentities(identities == null ? new ArrayList() : identities);
        return msg;
    }

    public List<Message> handleMsg(Message message) {
        List<Message> messages = new ArrayList<Message>();
        try {
            this.getPythonEntryPoint();
        }
        catch (NoSuchKernelException e) {
            return messages;
        }
        this.pep.sendMessage(new ObjectMapper().valueToTree((Object)message).toString());
        try {
            messages = this.getIopubMessages();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Message msg : messages) {
            msg.setParentHeader(message.getHeader());
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Integer n = port;
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

