/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.histogram.Histogram;
import com.twosigma.beakerx.chart.serializer.AbstractChartSerializer;
import java.io.IOException;
import java.util.Arrays;

public class HistogramSerializer
extends AbstractChartSerializer<Histogram> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String BIN_COUNT = "bin_count";
    public static final String COLOR = "color";
    public static final String COLORS = "colors";
    public static final String NAMES = "names";
    public static final String DISPLAY_MODE = "displayMode";
    public static final String CUMULATIVE = "cumulative";
    public static final String NORMED = "normed";
    public static final String LOG = "log";

    public void serialize(Histogram histogram, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.serialize(histogram, jgen);
        if (histogram.getColors() != null) {
            jgen.writeObjectField(COLORS, histogram.getColors());
        } else {
            jgen.writeObjectField(COLOR, (Object)histogram.getColor());
        }
        if (histogram.getListData() != null) {
            jgen.writeObjectField(GRAPHICS_LIST, histogram.getListData());
        } else {
            jgen.writeObjectField(GRAPHICS_LIST, Arrays.asList(histogram.getData()));
        }
        jgen.writeObjectField("right_close", (Object)histogram.getRightClose());
        if (histogram.getRangeMin() != null) {
            jgen.writeObjectField("range_min", (Object)histogram.getRangeMin());
        }
        if (histogram.getRangeMax() != null) {
            jgen.writeObjectField("range_max", (Object)histogram.getRangeMax());
        }
        jgen.writeObjectField(BIN_COUNT, (Object)histogram.getBinCount());
        jgen.writeObjectField(CUMULATIVE, (Object)histogram.getCumulative());
        jgen.writeObjectField(NORMED, (Object)histogram.getNormed());
        jgen.writeObjectField(LOG, (Object)histogram.getLog());
        jgen.writeObjectField(DISPLAY_MODE, (Object)histogram.getDisplayMode());
        jgen.writeObjectField(NAMES, histogram.getNames());
        jgen.writeEndObject();
    }
}

