/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.widgets;

import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.InteractiveBase;
import com.twosigma.beakerx.widget.Label;
import com.twosigma.beakerx.widget.ValueWidget;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.MethodClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interactive
extends InteractiveBase {
    private static Label label;
    private static final Logger logger;

    public static synchronized void interact(final MethodClosure function, Object ... parameters) {
        final List widgets = Interactive.widgetsFromAbbreviations((Object[])parameters);
        for (ValueWidget widget : widgets) {
            Comm comm = widget.getComm();
            Handler[] handlerArray = new Handler[1];
            ValueWidget valueWidget = widget;
            valueWidget.getClass();
            handlerArray[0] = new DOMWidget.ValueChangeMsgCallbackHandler(valueWidget){

                private void processCode(Object ... params) throws Exception {
                    Object call = function.call(this.getWidgetValues());
                    if (call instanceof String || call instanceof Number) {
                        label.setValue(call);
                    }
                }

                public void updateValue(Object value, Message message) {
                    try {
                        this.processCode(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Error occurred during updating interactive widget.", e);
                    }
                }

                private Object[] getWidgetValues() {
                    ArrayList<Serializable> ret = new ArrayList<Serializable>(widgets.size());
                    for (ValueWidget wid : widgets) {
                        ret.add(wid.getValue());
                    }
                    return ret.toArray(new Object[ret.size()]);
                }
            };
            comm.addMsgCallbackList(handlerArray);
            logger.info("interact Widget: " + widget.getClass().getName());
        }
        widgets.forEach(Widget::display);
        Object response = function.call(widgets.stream().map(ValueWidget::getValue).toArray());
        if (response instanceof Widget) {
            ((Widget)response).display();
        } else {
            label = new Label();
            label.setValue(response);
            label.display();
        }
    }

    static {
        logger = LoggerFactory.getLogger(Interactive.class);
    }
}

