/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import zmq.Address;
import zmq.Blob;
import zmq.Ctx;
import zmq.FQ;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.Utils;
import zmq.ValueReference;

public class Router
extends SocketBase {
    private final FQ fq;
    private boolean prefetched = false;
    private boolean identitySent = false;
    private Msg prefetchedId;
    private Msg prefetchedMsg;
    private boolean moreIn = false;
    private final Set<Pipe> anonymousPipes;
    private final Map<Blob, Outpipe> outpipes;
    private Pipe currentOut = null;
    private boolean moreOut = false;
    private int nextPeerId = Utils.generateRandom();
    private boolean mandatory = false;
    private boolean handover = false;

    public Router(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 6;
        this.fq = new FQ();
        this.prefetchedId = new Msg();
        this.prefetchedMsg = new Msg();
        this.anonymousPipes = new HashSet<Pipe>();
        this.outpipes = new HashMap<Blob, Outpipe>();
        this.options.recvIdentity = true;
    }

    @Override
    public void xattachPipe(Pipe pipe, boolean icanhasall) {
        assert (pipe != null);
        boolean identityOk = this.identifyPeer(pipe);
        if (identityOk) {
            this.fq.attach(pipe);
        } else {
            this.anonymousPipes.add(pipe);
        }
    }

    @Override
    public boolean xsetsockopt(int option, Object optval) {
        if (option == 33) {
            this.mandatory = (Integer)optval == 1;
            return true;
        }
        if (option == 56) {
            this.handover = (Integer)optval == 1;
            return true;
        }
        return false;
    }

    @Override
    public void xpipeTerminated(Pipe pipe) {
        if (!this.anonymousPipes.remove(pipe)) {
            Outpipe old = this.outpipes.remove(pipe.getIdentity());
            assert (old != null);
            this.fq.terminated(pipe);
            if (pipe == this.currentOut) {
                this.currentOut = null;
            }
        }
    }

    @Override
    public void xreadActivated(Pipe pipe) {
        if (!this.anonymousPipes.contains(pipe)) {
            this.fq.activated(pipe);
        } else {
            boolean identityOk = this.identifyPeer(pipe);
            if (identityOk) {
                this.anonymousPipes.remove(pipe);
                this.fq.attach(pipe);
            }
        }
    }

    @Override
    public void xwriteActivated(Pipe pipe) {
        for (Map.Entry<Blob, Outpipe> it : this.outpipes.entrySet()) {
            if (it.getValue().pipe != pipe) continue;
            assert (!it.getValue().active);
            it.getValue().active = true;
            return;
        }
        assert (false);
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (!this.moreOut) {
            assert (this.currentOut == null);
            if (msg.hasMore()) {
                this.moreOut = true;
                Blob identity = Blob.createBlob(msg.data(), true);
                Outpipe op = this.outpipes.get(identity);
                if (op != null) {
                    this.currentOut = op.pipe;
                    if (!this.currentOut.checkWrite()) {
                        op.active = false;
                        this.currentOut = null;
                        if (this.mandatory) {
                            this.moreOut = false;
                            this.errno.set(35);
                            return false;
                        }
                    }
                } else if (this.mandatory) {
                    this.moreOut = false;
                    this.errno.set(65);
                    return false;
                }
            }
            return true;
        }
        this.moreOut = msg.hasMore();
        if (this.currentOut != null) {
            boolean ok = this.currentOut.write(msg);
            if (!ok) {
                this.currentOut = null;
            } else if (!this.moreOut) {
                this.currentOut.flush();
                this.currentOut = null;
            }
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg = null;
        if (this.prefetched) {
            if (!this.identitySent) {
                msg = this.prefetchedId;
                this.prefetchedId = null;
                this.identitySent = true;
            } else {
                msg = this.prefetchedMsg;
                this.prefetchedMsg = null;
                this.prefetched = false;
            }
            this.moreIn = msg.hasMore();
            return msg;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        msg = this.fq.recvPipe(this.errno, pipe);
        while (msg != null && msg.isIdentity()) {
            msg = this.fq.recvPipe(this.errno, pipe);
        }
        if (msg == null) {
            return null;
        }
        assert (pipe.get() != null);
        if (this.moreIn) {
            this.moreIn = msg.hasMore();
        } else {
            this.prefetchedMsg = msg;
            this.prefetched = true;
            Blob identity = pipe.get().getIdentity();
            msg = new Msg(identity.data());
            msg.setFlags(1);
            this.identitySent = true;
        }
        return msg;
    }

    protected void rollback() {
        if (this.currentOut != null) {
            this.currentOut.rollback();
            this.currentOut = null;
            this.moreOut = false;
        }
    }

    @Override
    protected boolean xhasIn() {
        if (this.moreIn) {
            return true;
        }
        if (this.prefetched) {
            return true;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        while (this.prefetchedMsg != null && this.prefetchedMsg.isIdentity()) {
            this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        }
        if (this.prefetchedMsg == null) {
            return false;
        }
        assert (pipe.get() != null);
        Blob identity = pipe.get().getIdentity();
        this.prefetchedId = new Msg(identity.data());
        this.prefetchedId.setFlags(1);
        this.prefetched = true;
        this.identitySent = false;
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    private boolean identifyPeer(Pipe pipe) {
        Blob identity;
        ByteBuffer buf;
        Msg msg = pipe.read();
        if (msg == null) {
            return false;
        }
        if (msg.size() == 0) {
            buf = ByteBuffer.allocate(5);
            buf.put((byte)0);
            buf.putInt(this.nextPeerId++);
            identity = Blob.createBlob(buf.array(), false);
        } else {
            identity = Blob.createBlob(msg.data(), true);
            if (this.outpipes.containsKey(identity)) {
                if (!this.handover) {
                    return false;
                }
                buf = ByteBuffer.allocate(5);
                buf.put((byte)0);
                buf.putInt(this.nextPeerId++);
                Blob newIdentity = Blob.createBlob(buf.array(), false);
                Outpipe existingOutpipe = this.outpipes.remove(identity);
                existingOutpipe.pipe.setIdentity(newIdentity);
                this.outpipes.put(newIdentity, existingOutpipe);
                existingOutpipe.pipe.terminate(true);
            }
        }
        pipe.setIdentity(identity);
        Outpipe outpipe = new Outpipe(pipe, true);
        this.outpipes.put(identity, outpipe);
        return true;
    }

    class Outpipe {
        private Pipe pipe;
        private boolean active;

        public Outpipe(Pipe pipe, boolean active) {
            this.pipe = pipe;
            this.active = active;
        }
    }

    public static class RouterSession
    extends SessionBase {
        public RouterSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }
    }
}

