/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerTracker;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    private volatile Identikit myIdentikit;
    protected final SmartPointerManagerImpl myManager;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project, @Nullable ProperTextRange range, @NotNull Identikit identikit, @NotNull PsiFile containingFile, boolean forInjected) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (identikit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identikit", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myForInjected = forInjected;
        this.myIdentikit = identikit;
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project);
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange(range);
    }

    void switchToAnchor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "switchToAnchor"));
        }
        Pair<Identikit.ByAnchor, PsiElement> pair = Identikit.withAnchor(element, this.myIdentikit.getFileLanguage());
        if (pair != null) {
            assert (((Identikit.ByAnchor)pair.first).hashCode() == this.myIdentikit.hashCode());
            this.myIdentikit = (Identikit)pair.first;
            this.setRange(((PsiElement)pair.second).getTextRange());
        } else {
            this.setRange(element.getTextRange());
        }
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        } else {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isGreedy() {
        return this.myForInjected || this.myIdentikit.isForPsiFile();
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    public PsiElement restoreElement() {
        TextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file2 = this.restoreFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return this.myIdentikit.findPsiElement(file2, segment.getStartOffset(), segment.getEndOffset());
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        return this.calcPsiRange();
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myIdentikit.getFileLanguage());
    }

    @Override
    public void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(@NotNull VirtualFile virtualFile2, @NotNull Project project, @Nullable Language language) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "lambda$restoreFileFromVirtual$0"));
            }
            if (virtualFile2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "lambda$restoreFileFromVirtual$0"));
            }
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiFile file2 = PsiManager.getInstance(project).findFile(child);
            if (file2 != null && language != null) {
                return file2.getViewProvider().getPsi(language);
            }
            return file2;
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(VirtualFile virtualFile2, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile2 == null) {
            return null;
        }
        return ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "lambda$restoreDirectoryFromVirtual$1"));
            }
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiDirectory file2 = PsiManager.getInstance(project).findDirectory(child);
            if (file2 == null || !file2.isValid()) {
                return null;
            }
            return file2;
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile2) {
        VirtualFile child;
        if (virtualFile2.isValid()) {
            child = virtualFile2;
        } else {
            VirtualFile vParent = virtualFile2.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile2.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    public int elementHashCode() {
        return this.getVirtualFile().hashCode() + this.myIdentikit.hashCode() * 31;
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myIdentikit != otherInfo.myIdentikit) {
                return false;
            }
            return ReadAction.compute(() -> {
                TextRange range1 = this.getPsiRange();
                TextRange range2 = otherInfo.getPsiRange();
                return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
            });
        }
        return false;
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public Segment getRange() {
        SmartPointerTracker tracker;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (tracker = this.myManager.getTracker(this.getVirtualFile())) != null) {
            return tracker.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myIdentikit;
    }
}

