/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PreviewTableDisplay {
    public static int ROWS = 10;
    private VBox panel;
    private Collection<Map<String, Object>> preview;
    private Rows allRows;
    private List<Widget> previewContent;
    private List<Widget> rowsContent;

    public PreviewTableDisplay(Collection<Map<String, Object>> previewRows, Rows allRows, Count count) {
        this.allRows = allRows;
        this.preview = previewRows;
        this.previewContent = Arrays.asList(this.createShowRowsButton(), new TableDisplay(this.preview));
        this.panel = new VBox(this.previewContent);
    }

    private Button createShowRowsButton() {
        Button button = new Button();
        button.setDescription((Object)("Preview " + ROWS + " Rows"));
        button.registerOnClick((content, message) -> {
            if (this.rowsContent == null) {
                TableDisplay tableDisplay = new TableDisplay((Map[])this.allRows.get(ROWS + 1));
                tableDisplay.ROWS_LIMIT = ROWS;
                tableDisplay.ROW_LIMIT_TO_INDEX = ROWS;
                tableDisplay.setRowLimitMsg(String.format("Note: materializing a %s row preview of a Spark RDD", ROWS));
                this.rowsContent = Arrays.asList(tableDisplay);
            }
            this.changeContent(this.rowsContent);
        });
        return button;
    }

    private void changeContent(List<Widget> content) {
        this.panel.getLayout().setDisplayNone();
        this.panel.close();
        this.panel = new VBox(content);
        this.panel.display();
    }

    public void display() {
        this.panel.display();
    }

    public static interface Count {
        public Long get();
    }

    public static interface Rows {
        public Map<String, Object>[] get(int var1);
    }
}

