/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommand;
import com.twosigma.beakerx.scala.spark.SparkDisplayers;
import com.twosigma.beakerx.scala.spark.SparkImplicit;
import java.util.List;
import java.util.Optional;

public class LoadSparkSupportMagicCommand
implements MagicCommandFunctionality {
    public static final String LOAD_SPARK_SUPPORT = "%loadSparkSupport";
    private KernelFunctionality kernel;

    public LoadSparkSupportMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public String getMagicCommandName() {
        return LOAD_SPARK_SUPPORT;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        TryResult implicits = this.addImplicits(param.getCode().getMessage());
        if (implicits.isError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, implicits.error());
        }
        MagicCommandOutcomeItem loadSpark = this.loadSparkMagic();
        if (!loadSpark.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Can not run spark support");
        }
        SparkDisplayers.register();
        this.addDefaultImports();
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Spark support enabled");
    }

    private MagicCommandOutcomeItem loadSparkMagic() {
        Optional magic = CodeFactory.findMagicCommandFunctionality((List)this.kernel.getMagicCommandTypes(), (String)"%load_magic");
        MagicCommandOutcomeItem magicCommandOutcomeItem = ((LoadMagicMagicCommand)magic.get()).load(SparkMagicCommand.class.getName());
        return magicCommandOutcomeItem;
    }

    private TryResult addImplicits(Message parent) {
        String codeToExecute = new SparkImplicit().codeAsString();
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)codeToExecute, (KernelFunctionality)this.kernel, (Message)new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())), (int)1);
        return this.kernel.executeCode(codeToExecute, seo);
    }

    private void addDefaultImports() {
        this.kernel.addImport(new ImportPath("org.apache.spark.sql.SparkSession"));
    }
}

