/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.util.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder(value={"identities", "header", "parentHeader", "metadata", "content"})
public class Message {
    private List<byte[]> identities = new ArrayList<byte[]>();
    private Header header;
    @JsonProperty(value="parent_header")
    private Header parentHeader;
    private Map<String, Serializable> metadata;
    private Map<String, Serializable> content;
    private List<byte[]> buffers = new ArrayList<byte[]>();

    public Message(Header header) {
        this.header = Preconditions.checkNotNull(header);
        header.setDate(Utils.timestamp());
    }

    public JupyterMessages type() {
        return this.header != null && this.header.getTypeEnum() != null ? this.header.getTypeEnum() : null;
    }

    public List<byte[]> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<byte[]> identities) {
        this.identities = identities;
    }

    public Header getHeader() {
        return this.header;
    }

    public Header getParentHeader() {
        return this.parentHeader;
    }

    public void setParentHeader(Header parentHeader) {
        this.parentHeader = parentHeader;
    }

    public Map<String, Serializable> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Serializable> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Serializable> getContent() {
        return this.content;
    }

    public void setContent(Map<String, Serializable> content) {
        this.content = content;
    }

    public String toString() {
        return "Type = " + this.header.getType();
    }

    public void setBuffers(List<byte[]> buffers) {
        this.buffers = buffers;
    }

    public List<byte[]> getBuffers() {
        return this.buffers;
    }
}

