/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.Config;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.message.MessageSerializer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.Base64;

public class KernelConfigurationFile
implements ConfigurationFile {
    private static final Logger logger = LoggerFactory.getLogger(KernelConfigurationFile.class);
    private File config;
    private Config configuration;
    private Optional<String> context = Optional.empty();

    public KernelConfigurationFile(String[] args) {
        if (args.length > 2) {
            logger.error("Invalid parameters passed to the Kernel. Expected one or two parameter, found " + args.length);
            for (String string : args) {
                logger.error(string);
            }
            System.exit(1);
        }
        this.config = this.getConfig(args[0]);
        if (args.length == 2) {
            String contextAsJson = null;
            try {
                contextAsJson = new String(Base64.decode((String)args[1]), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.context = Optional.of(contextAsJson);
        }
    }

    @Override
    public Config getConfig() {
        if (this.configuration == null) {
            logger.debug("Path to config file : " + this.config.getAbsolutePath());
            this.configuration = MessageSerializer.parse(new String(this.readConfig(), StandardCharsets.UTF_8), Config.class);
            logger.debug("Creating signing hmac with: {}", (Object)this.configuration.getKey());
        }
        return this.configuration;
    }

    private byte[] readConfig() {
        byte[] bytes = new byte[]{};
        try {
            bytes = Files.readAllBytes(this.config.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    private File getConfig(String path) {
        File config = new File(path);
        if (!config.exists()) {
            logger.error("Kernel configuration not found.");
            System.exit(1);
        }
        return config;
    }

    public Optional<String> getContext() {
        return this.context;
    }
}

