/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.threads.BeakerSingleThreadFactory;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class BeakerCellExecutor
implements CellExecutor {
    private static final int KILL_THREAD_SLEEP_IN_MILLIS = 2000;
    private final String prefix;
    private final ReentrantLock theLock;
    private BeakerSingleThreadFactory thrFactory;
    private ThreadGroup thrGroup;
    private ExecutorService worker;
    private static AtomicInteger count = new AtomicInteger();
    private int killThreadSleepInMillis;

    public BeakerCellExecutor(String prf, int killThreadSleepInMillis) {
        this.prefix = prf;
        this.theLock = new ReentrantLock();
        this.thrGroup = new ThreadGroup(this.prefix + "TG" + count.getAndIncrement());
        this.killThreadSleepInMillis = killThreadSleepInMillis;
        this.reset();
    }

    public BeakerCellExecutor(String prf) {
        this(prf, 2000);
    }

    private void reset() {
        this.theLock.lock();
        this.thrFactory = new BeakerSingleThreadFactory(this.thrGroup, this.prefix);
        this.worker = Executors.newSingleThreadExecutor(this.thrFactory);
        this.theLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TryResult executeTask(Callable<TryResult> tsk) {
        Future<TryResult> ret;
        try {
            this.theLock.lock();
            ret = this.worker.submit(tsk);
        }
        catch (Throwable t) {
            t.printStackTrace();
            TryResult.CellError cellError = TryResult.createError(t.getMessage());
            return cellError;
        }
        finally {
            this.theLock.unlock();
        }
        TryResult o = null;
        try {
            o = ret.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return TryResult.createError(e.getMessage());
        }
        if (ret.isCancelled()) {
            return TryResult.createError("Cancelled");
        }
        return o;
    }

    @Override
    public void cancelExecution() {
        try {
            this.theLock.lock();
            this.worker.shutdownNow();
            Thread thr = this.thrFactory.getTheThread();
            this.killThread(thr);
        }
        finally {
            this.theLock.unlock();
            this.reset();
        }
    }

    public List<Thread> getThreadList() {
        Thread[] threads;
        int nAlloc = this.thrGroup.activeCount();
        if (nAlloc == 0) {
            return new ArrayList<Thread>();
        }
        int n = 0;
        while ((n = this.thrGroup.enumerate(threads = new Thread[nAlloc *= 2])) == nAlloc) {
        }
        return Arrays.asList(threads);
    }

    private void killThread(Thread thr) {
        if (null == thr) {
            return;
        }
        thr.interrupt();
        try {
            Thread.sleep(this.killThreadSleepInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thr.getState().equals((Object)Thread.State.TERMINATED)) {
            thr.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllThreads() {
        try {
            this.theLock.lock();
            this.worker.shutdownNow();
            Thread thr = this.thrFactory.getTheThread();
            this.killThread(thr);
            List<Thread> tlist = this.getThreadList();
            for (Thread t : tlist) {
                this.killThread(t);
            }
        }
        finally {
            this.theLock.unlock();
            this.reset();
        }
    }
}

