/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.AutotranslationService;
import com.twosigma.beakerx.AutotranslationServiceImpl;
import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.BeakerXJsonSerializer;
import com.twosigma.beakerx.CodeCell;
import com.twosigma.beakerx.CommRepository;
import com.twosigma.beakerx.DefaultBeakerXJsonSerializer;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelConfigurationFile;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;

public class NamespaceClient
implements BeakerXClient {
    private static Map<String, SynchronousQueue<Object>> messagePool = new HashMap<String, SynchronousQueue<Object>>();
    private Comm codeCellsComm = null;
    private Comm tagRunComm = null;
    private AutotranslationService autotranslationService;
    private BeakerXJsonSerializer beakerXJsonSerializer;
    private CommRepository commRepository;

    public NamespaceClient(AutotranslationService autotranslationService, BeakerXJsonSerializer beakerXJsonSerializer, CommRepository commRepository) {
        this.autotranslationService = autotranslationService;
        this.beakerXJsonSerializer = beakerXJsonSerializer;
        this.commRepository = commRepository;
    }

    @Override
    public synchronized void showProgressUpdate(String message, int progress) {
        SimpleEvaluationObject seo = InternalVariable.getSimpleEvaluationObject();
        seo.structuredUpdate(message, progress);
    }

    @Override
    public synchronized void delBeaker() {
        this.autotranslationService.close();
    }

    @Override
    public synchronized Object get(String name) {
        String json = this.autotranslationService.get(name);
        if ("undefined".equals(json)) {
            throw new RuntimeException("name '" + name + "' is not defined on the beakerx object");
        }
        return this.beakerXJsonSerializer.fromJson(json);
    }

    @Override
    public synchronized String update(String name, Object value) {
        try {
            String json = this.getJson(value);
            this.autotranslationService.update(name, json);
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Object set(String name, Object value) {
        String json = this.update(name, value);
        try {
            Comm c = this.commRepository.getOrCreateAutotranslationComm();
            HashMap data = new HashMap();
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("name", name);
            state.put("value", json);
            state.put("sync", true);
            data.put("state", state);
            data.put("buffer_paths", new HashMap());
            c.send(JupyterMessages.COMM_MSG, Comm.Buffer.EMPTY, new Comm.Data(data));
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getJson(Object value) {
        return this.beakerXJsonSerializer.toJson(value);
    }

    public Object setFast(String name, Object value) {
        throw new RuntimeException("This option is not implemented now");
    }

    public Object unset(String name) {
        throw new RuntimeException("This option is not implemented now");
    }

    @Override
    public SynchronousQueue<Object> getMessageQueue(String channel) {
        SynchronousQueue<Object> result = messagePool.get(channel);
        if (result == null) {
            result = new SynchronousQueue();
            messagePool.put(channel, result);
        }
        return result;
    }

    private Comm getCodeCellsComm() {
        if (this.codeCellsComm == null) {
            this.codeCellsComm = new Comm(TargetNamesEnum.BEAKER_GETCODECELLS);
            this.codeCellsComm.open();
        }
        return this.codeCellsComm;
    }

    private Comm getTagRunComm() {
        if (this.tagRunComm == null) {
            this.tagRunComm = new Comm(TargetNamesEnum.BEAKER_TAG_RUN);
            this.tagRunComm.open();
        }
        return this.tagRunComm;
    }

    @Override
    public List<CodeCell> getCodeCells(String tagFilter) {
        try {
            Comm c = this.getCodeCellsComm();
            HashMap data = new HashMap();
            HashMap<String, String> state = new HashMap<String, String>();
            state.put("name", "CodeCells");
            state.put("value", this.getJson(tagFilter));
            data.put("state", state);
            data.put("buffer_paths", new HashMap());
            c.send(JupyterMessages.COMM_MSG, Comm.Buffer.EMPTY, new Comm.Data(data));
            Object cells = this.getMessageQueue("CodeCells").take();
            return (List)cells;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void runByTag(String tag) {
        Comm c = this.getTagRunComm();
        HashMap data = new HashMap();
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("runByTag", tag);
        data.put("state", state);
        data.put("buffer_paths", new HashMap());
        c.send(JupyterMessages.COMM_MSG, Comm.Buffer.EMPTY, new Comm.Data(data));
    }

    @Override
    public String getContext() {
        return this.autotranslationService.getContextAsString();
    }

    public static NamespaceClient create(String id, KernelConfigurationFile configurationFile, CommRepository commRepository) {
        return NamespaceClient.create(id, configurationFile, new DefaultBeakerXJsonSerializer(), commRepository);
    }

    public static NamespaceClient create(String id, KernelConfigurationFile configurationFile, BeakerXJsonSerializer serializer, CommRepository commRepository) {
        if (configurationFile.getContext().isPresent()) {
            return new NamespaceClient(AutotranslationServiceImpl.createAsSubkernel(configurationFile.getContext().get()), serializer, commRepository);
        }
        return new NamespaceClient(AutotranslationServiceImpl.createAsMainKernel(id), serializer, commRepository);
    }
}

