/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.scala.evaluator.BeakerxObjectFactory;
import com.twosigma.beakerx.scala.evaluator.ScalaEvaluatorGlue;
import com.twosigma.beakerx.scala.evaluator.ScalaWorkerThread;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaEvaluator
extends BaseEvaluator {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaEvaluator.class.getName());
    private BeakerxObjectFactory beakerxObjectFactory;
    private BeakerXUrlClassLoader classLoader;
    private ScalaEvaluatorGlue shell;

    public ScalaEvaluator(String id, String sId, CellExecutor cellExecutor, BeakerxObjectFactory beakerxObjectFactory, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient);
        this.beakerxObjectFactory = beakerxObjectFactory;
        this.classLoader = this.newClassLoader();
        this.shell = this.createNewEvaluator();
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code) {
        return this.evaluate(seo, new ScalaWorkerThread(this, new JobDescriptor(code, seo)));
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.classLoader.addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        this.addImportToShell(this.shell, anImport);
    }

    protected void doReloadEvaluator() {
        this.shell = this.createNewEvaluator(this.shell);
    }

    protected void doResetEnvironment() {
        this.classLoader = this.newClassLoader();
        this.shell = this.createNewEvaluator();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void exit() {
        super.exit();
        this.cancelExecution();
        this.executorService.shutdown();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    ScalaEvaluatorGlue getShell() {
        return this.shell;
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        AutocompleteResult lineCompletion = this.shell.autocomplete(code, caretPosition);
        return new AutocompleteResult(lineCompletion.getMatches(), lineCompletion.getStartIndex());
    }

    private String adjustImport(String imp) {
        if (imp.startsWith("import")) {
            imp = imp.substring(6).trim();
        }
        if (imp.startsWith("static")) {
            imp = imp.substring(6).trim();
        }
        if (imp.contains(".object.")) {
            imp = imp.replace(".object.", ".`object`.");
        }
        if (imp.endsWith(".*")) {
            imp = imp.substring(0, imp.length() - 1) + "_";
        }
        return imp;
    }

    private ScalaEvaluatorGlue createNewEvaluator(ScalaEvaluatorGlue shell) {
        ScalaEvaluatorGlue newEvaluator = this.createNewEvaluator();
        this.setLineId(newEvaluator, shell.interpreter().lastRequest().lineRep().lineId());
        return newEvaluator;
    }

    private void setLineId(ScalaEvaluatorGlue newEvaluator, int lines) {
        for (int i = newEvaluator.interpreter().lastRequest().lineRep().lineId(); i < lines; ++i) {
            newEvaluator.evaluate2("\"\"");
        }
    }

    private ScalaEvaluatorGlue createNewEvaluator() {
        logger.debug("creating new evaluator");
        String loader_cp = this.createLoaderCp();
        ScalaEvaluatorGlue shell = new ScalaEvaluatorGlue((ClassLoader)this.classLoader, loader_cp, this.getOutDir());
        if (!this.getImports().isEmpty()) {
            this.addImportsToShell(shell, this.getImports().getImportPaths());
        }
        logger.debug("creating beaker object");
        String r = shell.evaluate2(this.beakerxObjectFactory.create());
        if (r != null && !r.isEmpty()) {
            logger.warn("ERROR creating beaker object: {}", (Object)r);
        }
        return shell;
    }

    private void addImportsToShell(ScalaEvaluatorGlue shell, List<ImportPath> importsPaths) {
        if (!importsPaths.isEmpty()) {
            String[] imp = (String[])importsPaths.stream().map(importPath -> this.adjustImport(importPath.asString())).toArray(String[]::new);
            logger.debug("importing : {}", importsPaths);
            if (!shell.addImports(imp)) {
                logger.warn("ERROR: cannot add import '{}'", (Object[])imp);
            }
        }
    }

    private void addImportToShell(ScalaEvaluatorGlue shell, ImportPath importPath) {
        String imp = importPath.asString().trim();
        if (!(imp = this.adjustImport(imp)).isEmpty()) {
            logger.debug("importing : {}", (Object)imp);
            if (!shell.addImport(imp)) {
                logger.warn("ERROR: cannot add import '{}'", (Object)imp);
            }
        }
    }

    private BeakerXUrlClassLoader newClassLoader() {
        logger.debug("creating new loader");
        BeakerXUrlClassLoader cl = new BeakerXUrlClassLoader(ClassLoader.getSystemClassLoader());
        cl.addPathToJars(this.getClasspath().getPaths());
        return cl;
    }

    private String createLoaderCp() {
        String loader_cp = "";
        for (int i = 0; i < this.getClasspath().size(); ++i) {
            loader_cp = loader_cp + this.getClasspath().get(i);
            loader_cp = loader_cp + File.pathSeparatorChar;
        }
        return loader_cp + File.pathSeparatorChar + System.getProperty("java.class.path");
    }
}

