/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASIN = 75;
    private static final int FUNC_ATAN = 76;
    private static final int FUNC_ATAN2 = 77;
    private static final int FUNC_BITAND = 78;
    private static final int FUNC_BITANDNOT = 79;
    private static final int FUNC_BITNOT = 80;
    private static final int FUNC_BITOR = 81;
    private static final int FUNC_BITXOR = 82;
    private static final int FUNC_CHAR = 83;
    private static final int FUNC_CONCAT = 84;
    private static final int FUNC_COS = 85;
    private static final int FUNC_COSH = 86;
    private static final int FUNC_COT = 87;
    private static final int FUNC_CRYPT_KEY = 88;
    private static final int FUNC_DATABASE = 89;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 90;
    private static final int FUNC_DATABASE_NAME = 91;
    private static final int FUNC_DATABASE_TIMEZONE = 92;
    private static final int FUNC_DATABASE_VERSION = 93;
    private static final int FUNC_DATE_ADD = 94;
    private static final int FUNC_DATE_SUB = 95;
    private static final int FUNC_DATEADD = 96;
    private static final int FUNC_DATEDIFF = 97;
    private static final int FUNC_DAYS = 98;
    private static final int FUNC_DBTIMEZONE = 99;
    private static final int FUNC_DEGREES = 100;
    private static final int FUNC_DIAGNOSTICS = 101;
    private static final int FUNC_DIFFERENCE = 102;
    private static final int FUNC_FROM_TZ = 103;
    private static final int FUNC_HEXTORAW = 104;
    private static final int FUNC_IDENTITY = 105;
    private static final int FUNC_INSTR = 106;
    private static final int FUNC_ISAUTOCOMMIT = 107;
    private static final int FUNC_ISOLATION_LEVEL = 108;
    private static final int FUNC_ISREADONLYDATABASE = 109;
    private static final int FUNC_ISREADONLYDATABASEFILES = 110;
    private static final int FUNC_ISREADONLYSESSION = 111;
    private static final int FUNC_LAST_DAY = 112;
    private static final int FUNC_LEFT = 113;
    private static final int FUNC_LOAD_FILE = 114;
    private static final int FUNC_LOB_ID = 115;
    private static final int FUNC_LOCATE = 116;
    private static final int FUNC_LOG10 = 117;
    private static final int FUNC_LPAD = 118;
    private static final int FUNC_LTRIM = 119;
    private static final int FUNC_MONTHS_BETWEEN = 120;
    private static final int FUNC_NEW_TIME = 121;
    private static final int FUNC_NEXT_DAY = 122;
    private static final int FUNC_NUMTODSINTERVAL = 123;
    private static final int FUNC_NUMTOYMINTERVAL = 124;
    private static final int FUNC_PI = 125;
    private static final int FUNC_POSITION_ARRAY = 126;
    private static final int FUNC_RADIANS = 127;
    private static final int FUNC_RAND = 128;
    private static final int FUNC_RAWTOHEX = 129;
    private static final int FUNC_REGEXP_MATCHES = 130;
    private static final int FUNC_REGEXP_REPLACE = 131;
    private static final int FUNC_REGEXP_SUBSTRING = 132;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 133;
    private static final int FUNC_REPEAT = 134;
    private static final int FUNC_REPLACE = 135;
    private static final int FUNC_REVERSE = 136;
    private static final int FUNC_RIGHT = 137;
    private static final int FUNC_ROUND = 138;
    private static final int FUNC_ROUNDMAGIC = 139;
    private static final int FUNC_RPAD = 140;
    private static final int FUNC_RTRIM = 141;
    private static final int FUNC_SECONDS_MIDNIGHT = 142;
    private static final int FUNC_SEQUENCE_ARRAY = 143;
    private static final int FUNC_SESSION_ID = 144;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 145;
    private static final int FUNC_SESSION_TIMEZONE = 146;
    private static final int FUNC_SESSIONTIMEZONE = 147;
    private static final int FUNC_SIGN = 148;
    private static final int FUNC_SIN = 149;
    private static final int FUNC_SINH = 150;
    private static final int FUNC_SOUNDEX = 151;
    private static final int FUNC_SORT_ARRAY = 152;
    private static final int FUNC_SPACE = 153;
    private static final int FUNC_SUBSTR = 154;
    private static final int FUNC_SYS_EXTRACT_UTC = 155;
    private static final int FUNC_SYSDATE = 156;
    private static final int FUNC_SYSTIMESTAMP = 157;
    private static final int FUNC_TAN = 158;
    private static final int FUNC_TANH = 159;
    private static final int FUNC_TIMESTAMP = 160;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 161;
    private static final int FUNC_TIMESTAMPADD = 162;
    private static final int FUNC_TIMESTAMPDIFF = 163;
    private static final int FUNC_TIMEZONE = 164;
    private static final int FUNC_TO_CHAR = 165;
    private static final int FUNC_TO_DATE = 166;
    private static final int FUNC_TO_DSINTERVAL = 167;
    private static final int FUNC_TO_YMINTERVAL = 168;
    private static final int FUNC_TO_NUMBER = 169;
    private static final int FUNC_TO_TIMESTAMP = 170;
    private static final int FUNC_TO_TIMESTAMP_TZ = 171;
    private static final int FUNC_TRANSACTION_CONTROL = 172;
    private static final int FUNC_TRANSACTION_ID = 173;
    private static final int FUNC_TRANSACTION_SIZE = 174;
    private static final int FUNC_TRANSLATE = 175;
    private static final int FUNC_TRUNC = 176;
    private static final int FUNC_TRUNCATE = 177;
    private static final int FUNC_UUID = 178;
    private static final int FUNC_UNIX_TIMESTAMP = 179;
    private static final int FUNC_UNIX_MILLIS = 180;
    private static final int FUNC_DATEPART = 182;
    private static final int FUNC_DATENAME = 183;
    private static final int FUNC_NANVL = 184;
    private static final int FUNC_SQLCODE = 185;
    private static final int FUNC_SQLERRM = 186;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(Session session, String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 453: 
            case 712: 
            case 760: 
            case 765: 
            case 781: 
            case 834: {
                return new FunctionSQL(n2);
            }
            case 723: 
            case 724: 
            case 778: 
            case 828: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 810: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                return functionSQL;
            }
            case 848: 
            case 849: 
            case 850: 
            case 851: {
                if (session.database.sqlSyntaxMss) break;
                return null;
            }
            case 742: 
            case 814: 
            case 853: {
                if (session.database.sqlSyntaxOra) break;
                return null;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 768: {
                    functionCustom.extractSpec = 161;
                    break;
                }
                case 796: {
                    functionCustom.extractSpec = 302;
                    break;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 737: {
                    functionCustom.extractSpec = 733;
                    break;
                }
                case 771: {
                    functionCustom.extractSpec = 770;
                    break;
                }
                case 738: {
                    functionCustom.extractSpec = 734;
                    break;
                }
                case 739: {
                    functionCustom.extractSpec = 735;
                    break;
                }
                case 740: {
                    functionCustom.extractSpec = 736;
                    break;
                }
                case 838: {
                    functionCustom.extractSpec = 839;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 185: 
            case 186: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 99: 
            case 147: 
            case 156: 
            case 157: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 125: 
            case 144: 
            case 145: 
            case 146: 
            case 164: 
            case 172: 
            case 173: 
            case 174: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 100: 
            case 104: 
            case 112: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 136: 
            case 139: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 161: 
            case 167: 
            case 168: 
            case 169: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 88: 
            case 102: 
            case 103: 
            case 113: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 137: 
            case 184: {
                this.parseList = doubleParamList;
                break;
            }
            case 165: 
            case 166: 
            case 170: 
            case 171: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 114: 
            case 138: 
            case 160: 
            case 176: 
            case 177: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 97: {
                this.parseList = new short[]{936, 1005, 924, 938, 924, 938, 922};
                this.parseListAlt = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 96: {
                this.parseList = new short[]{936, 1005, 924, 938, 924, 938, 922};
                this.parseListAlt = tripleParamList;
                break;
            }
            case 182: 
            case 183: {
                this.parseList = new short[]{936, 1005, 924, 938, 922};
                break;
            }
            case 94: 
            case 95: {
                this.parseList = doubleParamList;
                break;
            }
            case 121: 
            case 143: 
            case 175: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 118: 
            case 135: 
            case 140: {
                this.parseList = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 131: {
                this.parseList = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 105: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 101: {
                this.parseList = new short[]{936, 517, 922};
                break;
            }
            case 126: {
                this.parseList = new short[]{936, 938, 140, 938, 1002, 2, 124, 938, 922};
                break;
            }
            case 152: {
                this.parseList = new short[]{936, 938, 1002, 4, 1001, 2, 359, 410, 1002, 5, 473, 1001, 2, 423, 452, 922};
                break;
            }
            case 162: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{936, 1001, 10, 981, 982, 984, 985, 986, 987, 988, 989, 990, 991, 924, 938, 924, 938, 922};
                this.parseListAlt = new short[]{936, 1001, 10, 871, 872, 264, 179, 137, 78, 838, 183, 784, 340, 924, 938, 924, 938, 922};
                break;
            }
            case 163: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{936, 1001, 10, 981, 982, 984, 985, 986, 987, 988, 989, 990, 991, 924, 938, 924, 938, 922};
                this.parseListAlt = new short[]{936, 1001, 10, 871, 872, 264, 179, 137, 78, 838, 183, 784, 340, 924, 938, 924, 938, 922};
                break;
            }
            case 128: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    expressionArray2[0] = expressionArray[0];
                    expressionArray2[1] = expressionArray[1];
                    expressionArray2[3] = expressionArray[2];
                    expressionArray = expressionArray2;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                expressionArray2[0] = expressionArray[1];
                expressionArray2[1] = expressionArray[0];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 84: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 185: {
                return 0;
            }
            case 186: {
                return "Error";
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 89: {
                return session.getDatabase().getPath();
            }
            case 91: {
                return session.getDatabase().getNameString();
            }
            case 107: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 111: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 109: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 110: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 108: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 145: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 90: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 172: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 164: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 146: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 99: {
                TimestampData timestampData = session.getSystemTimestamp(true);
                IntervalSecondData intervalSecondData = new IntervalSecondData(timestampData.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 92: {
                int n = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(n, 0);
            }
            case 93: {
                return "2.4.0";
            }
            case 144: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 173: {
                return session.transactionTimestamp;
            }
            case 174: {
                return (long)session.actionIndex;
            }
            case 115: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 105: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 101: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 143: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(session, object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 162: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 873: 
                    case 981: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 871: 
                    case 983: {
                        long l3 = l / 1000000L;
                        int n3 = (int)(l % 1000000L) * 1000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 872: 
                    case 982: {
                        long l4 = l / 1000L;
                        int n4 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l4, n4, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 78: 
                    case 735: 
                    case 736: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 838: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 784: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 340: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 163: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    timestampData2 = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (n) {
                    case 873: 
                    case 981: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return new Long(1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos());
                    }
                    case 871: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return new Long(1000000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000));
                    }
                    case 872: 
                    case 982: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return new Long(1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000));
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 78: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 838: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 6L) / 7L : (l + 6L) / 7L;
                        return new Long(l);
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 784: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 2L) / 3L : (l + 2L) / 3L;
                        return new Long(l);
                    }
                    case 340: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 183: {
                Object object = this.getExtractValue(session, objectArray);
                return this.dataType.convertToDefaultType(session, object);
            }
            case 94: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.add(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 95: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 98: {
                if (objectArray[0] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, objectArray[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(intervalSecondData.getSeconds() / 86400L + 1L));
            }
            case 138: 
            case 176: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 138 ? dateTimeType.round(objectArray[0], n) : dateTimeType.truncate(objectArray[0], n);
                }
            }
            case 177: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 138 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 165: {
                if (this.nodes[1] == null) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return HsqlDateTime.toFormattedDate(date, (String)objectArray[1], simpleDateFormat);
            }
            case 169: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 166: 
            case 170: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateOrTimestampType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                boolean bl = this.funcType == 170;
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                TimestampData timestampData = HsqlDateTime.toDate((String)objectArray[0], (String)objectArray[1], simpleDateFormat, bl);
                return timestampData;
            }
            case 160: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        return new TimestampData(((Number)objectArray[0]).longValue());
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException hsqlException) {
                        return Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 161: {
                int n;
                long l;
                Calendar calendar = session.getCalendar();
                int n5 = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    l = ((Number)objectArray[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                    l = HsqlDateTime.convertMillisToCalendar(calendar, l * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)objectArray[1]);
                }
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.setTimeInMillis(l * 1000L);
                    n = HsqlDateTime.getZoneSeconds(calendar);
                }
                return new TimestampData(l, n5, n);
            }
            case 125: {
                return new Double(Math.PI);
            }
            case 128: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return new Double(session.random(l));
            }
            case 178: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l5 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l5), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    if (this.dataType.isBinaryType()) {
                        byte[] byArray = StringConverter.toBinaryUUID((String)objectArray[0]);
                        return new BinaryData(byArray, false);
                    }
                    return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
                }
                catch (NumberFormatException numberFormatException) {
                    throw Error.error(3459);
                }
            }
            case 180: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                long l = timestampData.getSeconds() * 1000L + (long)(timestampData.getNanos() / 1000000);
                return l;
            }
            case 179: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                return timestampData.getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.acos(d));
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.asin(d));
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.atan(d));
            }
            case 85: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.cos(d));
            }
            case 86: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.cosh(d));
            }
            case 87: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return new Double(d2);
            }
            case 100: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toDegrees(d));
            }
            case 149: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.sin(d));
            }
            case 150: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.sinh(d));
            }
            case 158: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.tan(d));
            }
            case 159: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.tanh(d));
            }
            case 117: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.log10(d));
            }
            case 127: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toRadians(d));
            }
            case 148: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (session.database.sqlSyntaxOra && objectArray[0] instanceof Double && (Double)objectArray[0] == 0.0) {
                    return 1;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return n;
            }
            case 77: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return new Double(Math.atan2(d, d3));
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 83: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 139: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 151: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long l = 0L;
                    long l6 = 0L;
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    long l7 = ((Number)objectArray[0]).longValue();
                    if (this.funcType != 80) {
                        objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                        l6 = ((Number)objectArray[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 78: {
                            l = l7 & l6;
                            break;
                        }
                        case 79: {
                            l = l7 & (l6 ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 80: {
                            l = l7 ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 81: {
                            l = l7 | l6;
                            break;
                        }
                        case 82: {
                            l = l7 ^ l6;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)l);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = null;
                if (this.funcType != 80) {
                    byArray3 = ((BinaryData)objectArray[1]).getBytes();
                }
                switch (this.funcType) {
                    case 78: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 79: {
                        byArray3 = BitMap.not(byArray3);
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 80: {
                        byArray = BitMap.not(byArray2);
                        break;
                    }
                    case 81: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 82: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 102: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                int n6 = 1;
                block172: for (int i = 1; i < 4; ++i) {
                    for (int j = n6; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        n6 = j + 1;
                        continue block172;
                    }
                }
                return ValuePool.getInt(n);
            }
            case 104: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 129: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 134: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuffer stringBuffer = new StringBuffer(string.length() * n);
                while (n-- > 0) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            case 135: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                if (string2.length() == 0) {
                    return string;
                }
                while (true) {
                    int n7;
                    if ((n7 = string.indexOf(string2, n)) == -1) break;
                    stringBuffer.append(string.substring(n, n7));
                    stringBuffer.append(string3);
                    n = n7 + string2.length();
                }
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            case 113: 
            case 137: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = ((Number)objectArray[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, objectArray[0], 0L, n, true, this.funcType == 137);
            }
            case 153: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 136: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer((String)objectArray[0]);
                stringBuffer = stringBuffer.reverse();
                return stringBuffer.toString();
            }
            case 131: {
                String string;
                int n;
                for (n = 0; n < this.nodes.length && this.nodes[n] != null; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = FunctionCustom.regexpParams((String)objectArray[5]);
                Pattern pattern = null;
                String string4 = (String)objectArray[0];
                String string5 = (String)objectArray[1];
                String string6 = (String)objectArray[2];
                boolean bl = this.nodes[1].getType() == 1;
                int n8 = 1;
                int n9 = 0;
                if (this.nodes[4] != null) {
                    n9 = ((Number)objectArray[4]).intValue();
                }
                if (bl) {
                    pattern = this.pattern;
                }
                if (pattern == null) {
                    pattern = Pattern.compile(string5, n);
                }
                if (bl) {
                    this.pattern = pattern;
                }
                Matcher matcher = pattern.matcher(string4);
                if (n8 > 1) {
                    matcher.region(n8 - 1, string4.length());
                }
                if (n9 == 0) {
                    string = matcher.replaceAll(string6);
                } else if (n9 == 1) {
                    string = matcher.replaceFirst(string6);
                } else {
                    throw Error.error(3472, "count");
                }
                return string;
            }
            case 130: 
            case 132: 
            case 133: {
                Object object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                Object object3 = this.pattern;
                if (object3 == null) {
                    object = (String)objectArray[1];
                    object3 = Pattern.compile((String)object);
                }
                object = ((Pattern)object3).matcher((String)objectArray[0]);
                switch (this.funcType) {
                    case 130: {
                        boolean bl = ((Matcher)object).matches();
                        return bl;
                    }
                    case 132: {
                        boolean bl = ((Matcher)object).find();
                        if (bl) {
                            return ((Matcher)object).group();
                        }
                        return null;
                    }
                    case 133: {
                        HsqlArrayList hsqlArrayList = new HsqlArrayList();
                        while (((Matcher)object).find()) {
                            hsqlArrayList.add(((Matcher)object).group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
            }
            case 88: {
                Object object3 = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString((byte[])object3);
            }
            case 114: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string);
            }
            case 118: 
            case 140: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, objectArray[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]));
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string7 = " ";
                if (this.nodes[2] != null && (string7 = this.nodes[2].dataType.convertToString(objectArray[2])).length() == 0) {
                    string7 = " ";
                }
                string = (String)Type.SQL_VARCHAR.trim(session, string, ' ', true, true);
                string = StringUtil.toPaddedString(string, n, string7, this.funcType == 140);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string, Type.SQL_VARCHAR);
                }
                return string;
            }
            case 126: {
                if (objectArray[1] == null) {
                    return null;
                }
                if (objectArray[2] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                if (n <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 152: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 410;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 452;
                Object object = ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, object, sortAndSlice);
                return object;
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, timestampData, n);
            }
            case 103: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                return new TimestampData(timestampData.getSeconds() - intervalSecondData.getSeconds(), timestampData.getNanos(), (int)intervalSecondData.getSeconds());
            }
            case 112: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, objectArray[0]);
            }
            case 120: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)objectArray[0], (TimestampData)objectArray[1]);
            }
            case 184: {
                if (objectArray[0] == null) {
                    return null;
                }
                Double d = NumberType.toDouble(objectArray[0]);
                if (Double.isNaN(d)) {
                    return this.dataType.convertToType(session, objectArray[1], this.nodes[1].dataType);
                }
                return objectArray[0];
            }
            case 121: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                IntervalSecondData intervalSecondData2 = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                Object object = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(objectArray[0], Type.SQL_TIMESTAMP, (int)intervalSecondData2.getSeconds(), (int)intervalSecondData.getSeconds());
                return Type.SQL_TIMESTAMP.convertToType(session, object, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
            }
            case 122: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                int n = DateTimeType.getDayOfWeek((String)objectArray[1]);
                return DateTimeType.nextDayOfWeek(session, timestampData, n);
            }
            case 123: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n10 = IntervalType.getFieldNameTypeForToken(n);
                switch (n10) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalSecondData.newInterval(d, n10);
            }
            case 124: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n11 = IntervalType.getFieldNameTypeForToken(n);
                switch (n11) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalMonthData.newInterval(d, n11);
            }
            case 147: {
                IntervalSecondData intervalSecondData = new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 155: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(objectArray[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, 0);
            }
            case 156: {
                TimestampData timestampData = session.getSystemTimestamp(false);
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestampData, Type.SQL_TIMESTAMP);
            }
            case 157: {
                return session.getSystemTimestamp(true);
            }
            case 167: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 168: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 171: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
            }
            case 175: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap intKeyIntValueHashMap = this.charLookup;
                if (intKeyIntValueHashMap == null) {
                    intKeyIntValueHashMap = FunctionCustom.getTranslationMap((String)objectArray[1], (String)objectArray[2]);
                }
                return FunctionCustom.translateWithMap((String)objectArray[0], intKeyIntValueHashMap);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 185: {
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 186: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression);
                return;
            }
            case 89: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 91: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 90: 
            case 93: 
            case 108: 
            case 145: 
            case 172: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 92: 
            case 146: 
            case 164: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 105: 
            case 115: 
            case 144: 
            case 173: 
            case 174: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 101: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 143: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 96: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 162;
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 162: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode == 91) {
                    // empty if block
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.typeCode == 91) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                    switch (n) {
                        case 137: 
                        case 179: 
                        case 264: 
                        case 871: 
                        case 872: 
                        case 873: 
                        case 981: 
                        case 982: 
                        case 984: 
                        case 985: 
                        case 986: {
                            this.dataType = Type.SQL_TIMESTAMP;
                        }
                    }
                }
                return;
            }
            case 97: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(987), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 163;
            }
            case 163: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType.isCharacterType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[2].dataType.isCharacterType()) {
                    this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                block75 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode == 92 || this.nodes[2].dataType.typeCode == 94) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 987: 
                            case 988: 
                            case 989: 
                            case 990: 
                            case 991: {
                                break block75;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode != 92 && this.nodes[2].dataType.typeCode != 94) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 182: {
                if (this.extractSpec != 0) {
                    return;
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.funcType = 5;
                super.resolveTypes(session, expression);
                return;
            }
            case 183: {
                if (this.extractSpec != 0) {
                    return;
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                if (this.extractSpec == 735) {
                    this.extractSpec = 733;
                } else if (this.extractSpec == 183) {
                    this.extractSpec = 770;
                }
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 94: 
            case 95: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 98: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 138: 
            case 176: {
                int n2;
                int n3 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        if (expression instanceof ExpressionLogical || expression instanceof ExpressionArithmetic) {
                            for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                                if (expression.nodes[n2].dataType == null) continue;
                                this.nodes[0].dataType = expression.nodes[n2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 177: {
                int n2;
                Number number = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number != null) {
                    n2 = number;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > this.dataType.scale) {
                        n2 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n2 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n2, n2);
                    }
                }
                return;
            }
            case 165: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[0].dataType.isDateTimeType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 169: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 166: 
            case 170: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 170) {
                        string = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 166 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 160: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 161: {
                Type type = this.nodes[0].dataType;
                if (type == null) {
                    type = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 125: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 178: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 179: 
            case 180: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 128: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 75: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 100: 
            case 117: 
            case 127: 
            case 139: 
            case 149: 
            case 150: 
            case 158: 
            case 159: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 148: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 77: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 151: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.funcType == 80) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (n = 0; n < this.nodes.length; ++n) {
                        if (this.nodes[n].dataType != null) continue;
                        this.nodes[n].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 83: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 102: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 129: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 134: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 135: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 113: 
            case 137: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 153: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 136: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 131: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
            }
            case 130: 
            case 132: 
            case 133: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 130: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break block0;
                    }
                    case 131: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 132: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 133: {
                        this.dataType = Type.getDefaultArrayType(12);
                        break block0;
                    }
                }
                break;
            }
            case 88: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 114: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 118: 
            case 140: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                break;
            }
            case 126: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType.collectionBaseType();
                }
                if (!this.nodes[1].dataType.collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 152: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(359), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(423), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 99: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 112: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP_NO_FRACTION);
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 184: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_DOUBLE);
                }
                this.dataType = this.nodes[0].dataType;
            }
            case 121: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 124: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 147: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 156: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 157: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 167: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 168: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 171: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 175: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[n].dataType.isCharacterType() && !this.nodes[n].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = FunctionCustom.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer stringBuffer = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuffer.append(",").append(this.nodes[3].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 118: 
            case 140: {
                StringBuffer stringBuffer = new StringBuffer(this.name);
                stringBuffer.append("(").append(this.nodes[0].getSQL());
                stringBuffer.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuffer.append(",").append(this.nodes[2].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 126: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL()).append(' ').append("IN");
                stringBuffer.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 410) {
                    stringBuffer.append(' ').append("FROM");
                    stringBuffer.append(' ').append(this.nodes[2].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 152: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 410) {
                    stringBuffer.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 452) {
                    stringBuffer.append(' ').append("NULLS").append(' ');
                    stringBuffer.append("LAST");
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 156: 
            case 157: {
                return this.name;
            }
            case 72: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 125: 
            case 144: 
            case 145: 
            case 146: 
            case 164: 
            case 172: 
            case 173: 
            case 174: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 162: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 163: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 94: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('+').append(this.nodes[1].getSQL()).toString();
            }
            case 95: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('-').append(this.nodes[1].getSQL()).toString();
            }
            case 128: 
            case 179: 
            case 180: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    stringBuffer.append(this.nodes[0].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 114: 
            case 138: 
            case 160: 
            case 165: 
            case 166: 
            case 169: 
            case 170: 
            case 171: 
            case 176: 
            case 177: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    stringBuffer.append(',').append(this.nodes[1].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 100: 
            case 104: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 136: 
            case 139: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 158: 
            case 159: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 102: 
            case 113: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 137: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 101: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append("ROW_COUNT");
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 131: 
            case 135: 
            case 143: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
            case 73: 
            case 99: 
            case 103: 
            case 112: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 147: 
            case 155: 
            case 167: 
            case 168: 
            case 175: 
            case 182: 
            case 183: 
            case 184: {
                return this.getSQLSimple();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.nodes[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    private static int getTSIToken(String string) {
        int n;
        if ("yy".equalsIgnoreCase(string) || "yyyy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            n = 991;
        } else if ("qq".equalsIgnoreCase(string) || "quarter".equalsIgnoreCase(string)) {
            n = 990;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            n = 989;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            n = 987;
        } else if ("dy".equalsIgnoreCase(string) || "dayofyear".equalsIgnoreCase(string)) {
            n = 736;
        } else if ("dw".equalsIgnoreCase(string) || "weekday".equalsIgnoreCase(string)) {
            n = 735;
        } else if ("wk".equalsIgnoreCase(string) || "week".equalsIgnoreCase(string)) {
            n = 988;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            n = 986;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            n = 985;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            n = 984;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            n = 982;
        } else if ("mcs".equalsIgnoreCase(string) || "microsecond".equalsIgnoreCase(string)) {
            n = 983;
        } else if ("ns".equalsIgnoreCase(string) || "nanosecond".equalsIgnoreCase(string)) {
            n = 981;
        } else if ("tz".equalsIgnoreCase(string) || "tzoffset".equalsIgnoreCase(string)) {
            n = 820;
        } else {
            throw Error.error(5566, string);
        }
        return n;
    }

    private static int getExtractTokenForTSIPart(int n) {
        switch (n) {
            case 981: {
                return 873;
            }
            case 982: {
                return 872;
            }
            case 984: {
                return 264;
            }
            case 985: {
                return 179;
            }
            case 986: {
                return 137;
            }
            case 987: {
                return 78;
            }
            case 735: {
                return 735;
            }
            case 736: {
                return 736;
            }
            case 820: {
                return 820;
            }
            case 988: {
                return 839;
            }
            case 989: {
                return 183;
            }
            case 990: {
                return 784;
            }
            case 991: {
                return 340;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    static int getSQLTypeForToken(String string) {
        int n = -1;
        if ("YEAR_MONTH".equalsIgnoreCase(string)) {
            n = 107;
        } else if ("DAY_HOUR".equalsIgnoreCase(string)) {
            n = 108;
        } else if ("DAY_MINUTE".equalsIgnoreCase(string)) {
            n = 109;
        } else if ("DAY_SECOND".equalsIgnoreCase(string)) {
            n = 110;
        } else if ("DAY_MICROSECOND".equalsIgnoreCase(string)) {
            n = 110;
        } else if ("HOUR_MINUTE".equalsIgnoreCase(string)) {
            n = 111;
        } else if ("HOUR_SECOND".equalsIgnoreCase(string)) {
            n = 112;
        } else if ("HOUR_MICROSECOND".equalsIgnoreCase(string)) {
            n = 112;
        } else if ("MINUTE_SECOND".equalsIgnoreCase(string)) {
            n = 113;
        } else if ("MINUTE_MICROSECOND".equalsIgnoreCase(string)) {
            n = 113;
        } else if ("SECOND_MICROSECOND".equalsIgnoreCase(string)) {
            n = 106;
        }
        return n;
    }

    private static IntKeyIntValueHashMap getTranslationMap(String string, String string2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = new IntKeyIntValueHashMap();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i >= string2.length()) {
                intKeyIntValueHashMap.put(c, -1);
                continue;
            }
            char c2 = string2.charAt(i);
            intKeyIntValueHashMap.put(c, c2);
        }
        return intKeyIntValueHashMap;
    }

    private static String translateWithMap(String string, IntKeyIntValueHashMap intKeyIntValueHashMap) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = intKeyIntValueHashMap.get((int)c, -2);
            if (n == -2) {
                stringBuffer.append(c);
                continue;
            }
            if (n == -1) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private static int regexpParams(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 2;
                    continue block6;
                }
                case 'c': {
                    n &= 0xFFFFFFFD;
                    n |= 0x40;
                    continue block6;
                }
                case 'n': {
                    n |= 0x20;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                default: {
                    throw Error.error(3472, string);
                }
            }
        }
        return n;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(92);
        nonDeterministicFuncSet.add(105);
        nonDeterministicFuncSet.add(107);
        nonDeterministicFuncSet.add(111);
        nonDeterministicFuncSet.add(109);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(108);
        nonDeterministicFuncSet.add(144);
        nonDeterministicFuncSet.add(145);
        nonDeterministicFuncSet.add(146);
        nonDeterministicFuncSet.add(147);
        nonDeterministicFuncSet.add(156);
        nonDeterministicFuncSet.add(157);
        nonDeterministicFuncSet.add(160);
        nonDeterministicFuncSet.add(164);
        nonDeterministicFuncSet.add(172);
        nonDeterministicFuncSet.add(173);
        nonDeterministicFuncSet.add(174);
        nonDeterministicFuncSet.add(178);
        nonDeterministicFuncSet.add(179);
        nonDeterministicFuncSet.add(180);
        customRegularFuncMap.put(701, 71);
        customRegularFuncMap.put(702, 72);
        customRegularFuncMap.put(705, 73);
        customRegularFuncMap.put(703, 152);
        customRegularFuncMap.put(704, 74);
        customRegularFuncMap.put(706, 75);
        customRegularFuncMap.put(707, 76);
        customRegularFuncMap.put(708, 77);
        customRegularFuncMap.put(710, 78);
        customRegularFuncMap.put(711, 79);
        customRegularFuncMap.put(712, 6);
        customRegularFuncMap.put(713, 80);
        customRegularFuncMap.put(714, 81);
        customRegularFuncMap.put(715, 82);
        customRegularFuncMap.put(36, 83);
        customRegularFuncMap.put(716, 83);
        customRegularFuncMap.put(717, 84);
        customRegularFuncMap.put(719, 85);
        customRegularFuncMap.put(720, 86);
        customRegularFuncMap.put(721, 87);
        customRegularFuncMap.put(722, 88);
        customRegularFuncMap.put(723, 43);
        customRegularFuncMap.put(724, 51);
        customRegularFuncMap.put(605, 89);
        customRegularFuncMap.put(726, 91);
        customRegularFuncMap.put(725, 90);
        customRegularFuncMap.put(727, 92);
        customRegularFuncMap.put(728, 93);
        customRegularFuncMap.put(729, 94);
        customRegularFuncMap.put(730, 95);
        customRegularFuncMap.put(731, 96);
        customRegularFuncMap.put(732, 97);
        customRegularFuncMap.put(848, 183);
        customRegularFuncMap.put(849, 182);
        customRegularFuncMap.put(78, 5);
        customRegularFuncMap.put(737, 5);
        customRegularFuncMap.put(738, 5);
        customRegularFuncMap.put(739, 5);
        customRegularFuncMap.put(740, 5);
        customRegularFuncMap.put(741, 98);
        customRegularFuncMap.put(742, 99);
        customRegularFuncMap.put(744, 100);
        customRegularFuncMap.put(412, 101);
        customRegularFuncMap.put(745, 102);
        customRegularFuncMap.put(850, 112);
        customRegularFuncMap.put(747, 103);
        customRegularFuncMap.put(748, 104);
        customRegularFuncMap.put(137, 5);
        customRegularFuncMap.put(138, 105);
        customRegularFuncMap.put(145, 32);
        customRegularFuncMap.put(752, 1);
        customRegularFuncMap.put(753, 107);
        customRegularFuncMap.put(754, 109);
        customRegularFuncMap.put(755, 110);
        customRegularFuncMap.put(756, 111);
        customRegularFuncMap.put(757, 108);
        customRegularFuncMap.put(759, 112);
        customRegularFuncMap.put(760, 26);
        customRegularFuncMap.put(163, 113);
        customRegularFuncMap.put(453, 7);
        customRegularFuncMap.put(762, 114);
        customRegularFuncMap.put(769, 115);
        customRegularFuncMap.put(763, 1);
        customRegularFuncMap.put(765, 14);
        customRegularFuncMap.put(766, 117);
        customRegularFuncMap.put(767, 118);
        customRegularFuncMap.put(768, 31);
        customRegularFuncMap.put(179, 5);
        customRegularFuncMap.put(183, 5);
        customRegularFuncMap.put(771, 5);
        customRegularFuncMap.put(772, 120);
        customRegularFuncMap.put(852, 184);
        customRegularFuncMap.put(851, 178);
        customRegularFuncMap.put(775, 121);
        customRegularFuncMap.put(776, 122);
        customRegularFuncMap.put(779, 123);
        customRegularFuncMap.put(780, 124);
        customRegularFuncMap.put(781, 8);
        customRegularFuncMap.put(782, 125);
        customRegularFuncMap.put(783, 126);
        customRegularFuncMap.put(784, 5);
        customRegularFuncMap.put(785, 127);
        customRegularFuncMap.put(786, 128);
        customRegularFuncMap.put(787, 129);
        customRegularFuncMap.put(788, 130);
        customRegularFuncMap.put(789, 131);
        customRegularFuncMap.put(790, 132);
        customRegularFuncMap.put(791, 133);
        customRegularFuncMap.put(248, 134);
        customRegularFuncMap.put(792, 135);
        customRegularFuncMap.put(793, 136);
        customRegularFuncMap.put(254, 137);
        customRegularFuncMap.put(794, 138);
        customRegularFuncMap.put(795, 139);
        customRegularFuncMap.put(797, 140);
        customRegularFuncMap.put(796, 31);
        customRegularFuncMap.put(264, 5);
        customRegularFuncMap.put(798, 5);
        customRegularFuncMap.put(799, 143);
        customRegularFuncMap.put(800, 144);
        customRegularFuncMap.put(801, 145);
        customRegularFuncMap.put(802, 146);
        customRegularFuncMap.put(803, 147);
        customRegularFuncMap.put(804, 148);
        customRegularFuncMap.put(805, 149);
        customRegularFuncMap.put(806, 150);
        customRegularFuncMap.put(807, 152);
        customRegularFuncMap.put(808, 151);
        customRegularFuncMap.put(536, 153);
        customRegularFuncMap.put(810, 23);
        customRegularFuncMap.put(812, 155);
        customRegularFuncMap.put(813, 156);
        customRegularFuncMap.put(814, 157);
        customRegularFuncMap.put(815, 158);
        customRegularFuncMap.put(816, 159);
        customRegularFuncMap.put(298, 160);
        customRegularFuncMap.put(817, 161);
        customRegularFuncMap.put(818, 162);
        customRegularFuncMap.put(819, 163);
        customRegularFuncMap.put(820, 164);
        customRegularFuncMap.put(821, 165);
        customRegularFuncMap.put(822, 166);
        customRegularFuncMap.put(823, 167);
        customRegularFuncMap.put(824, 168);
        customRegularFuncMap.put(825, 169);
        customRegularFuncMap.put(826, 170);
        customRegularFuncMap.put(829, 172);
        customRegularFuncMap.put(830, 173);
        customRegularFuncMap.put(831, 174);
        customRegularFuncMap.put(303, 175);
        customRegularFuncMap.put(832, 176);
        customRegularFuncMap.put(311, 177);
        customRegularFuncMap.put(834, 27);
        customRegularFuncMap.put(835, 180);
        customRegularFuncMap.put(836, 179);
        customRegularFuncMap.put(853, 178);
        customRegularFuncMap.put(837, 178);
        customRegularFuncMap.put(838, 5);
        customRegularFuncMap.put(340, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(828, 43);
        customValueFuncMap.put(778, 52);
    }
}

