/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.outcome;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.util.Preconditions;
import java.util.Collections;
import java.util.Optional;

public class MagicCommandResult
implements MagicCommandOutcomeItem {
    private MagicCommandOutcomeItem.Status status;
    private Optional<MIMEContainer> mimeContainer;

    public MagicCommandResult(MagicCommandOutcomeItem.Status status, MIMEContainer mimeContainer) {
        this.status = status;
        this.mimeContainer = Optional.of(Preconditions.checkNotNull(mimeContainer));
    }

    @Override
    public Optional<MIMEContainer> getMIMEContainer() {
        return this.mimeContainer;
    }

    @Override
    public MagicCommandOutcomeItem.Status getStatus() {
        return this.status;
    }

    @Override
    public TryResult getResult() {
        return null;
    }

    @Override
    public SimpleEvaluationObject getSimpleEvaluationObject() {
        return null;
    }

    @Override
    public void sendRepliesWithStatus(KernelFunctionality kernel, Message message, int executionCount) {
        if (this.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            this.publishMessage(kernel, message, executionCount);
            kernel.send(MessageCreator.buildReplyWithOkStatus(message, executionCount));
        } else {
            this.publishMessage(kernel, message, executionCount);
            kernel.send(MessageCreator.buildReplyWithErrorStatus(message, executionCount));
        }
    }

    @Override
    public void sendMagicCommandOutcome(KernelFunctionality kernel, Message message, int executionCount) {
        this.publishMessage(kernel, message, executionCount);
    }

    private void publishMessage(KernelFunctionality kernel, Message message, int executionCount) {
        MIMEContainer mimeContainer = this.getMIMEContainer().get();
        kernel.publish(Collections.singletonList(MessageCreator.buildMessage(message, Collections.singletonList(mimeContainer), executionCount)));
    }
}

