/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import java.util.Map;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

class ByNameSingleExtractor<T>
implements Extractor<T, Object> {
    private final String propertyOrFieldName;

    @VisibleForTesting
    ByNameSingleExtractor(String propertyOrFieldName) {
        this.propertyOrFieldName = propertyOrFieldName;
    }

    @Override
    public Object extract(T input) {
        if (this.propertyOrFieldName == null) {
            throw new IllegalArgumentException("The name of the field/property to read should not be null");
        }
        if (this.propertyOrFieldName.length() == 0) {
            throw new IllegalArgumentException("The name of the field/property to read should not be empty");
        }
        if (input == null) {
            throw new IllegalArgumentException("The object to extract field/property from should not be null");
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            return map.get(this.propertyOrFieldName);
        }
        return PropertyOrFieldSupport.EXTRACTION.getValueOf(this.propertyOrFieldName, input);
    }
}

