/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.VBox;
import java.util.ArrayList;
import java.util.HashMap;

public class SparkStateProgress
extends VBox {
    public static final String VIEW_NAME_VALUE = "SparkStateProgressView";
    public static final String MODEL_NAME_VALUE = "SparkStateProgressModel";
    private int active = 0;
    private int done = 0;
    private int numberOfTasks = 0;
    private int jobId;
    private int stageId;
    private String jobLink;
    private String stageLink;

    public SparkStateProgress(int numTasks, int jobId, int stageId, String jobLink, String stageLink) {
        super(new ArrayList());
        this.init(numTasks, jobId, stageId, jobLink, stageLink);
    }

    private void init(int numTasks, int jobId, int stageId, String jobLink, String stageLink) {
        this.numberOfTasks = numTasks;
        this.jobId = jobId;
        this.stageId = stageId;
        this.jobLink = jobLink;
        this.stageLink = stageLink;
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public int getActive() {
        return this.active;
    }

    public int getDone() {
        return this.done;
    }

    public int getWaiting() {
        return this.getNumberOfTasks() - (this.done + this.active);
    }

    public synchronized void addActive() {
        ++this.active;
        this.sendState();
    }

    public synchronized void addDone() {
        ++this.done;
        --this.active;
        this.sendState();
    }

    public synchronized void init() {
        this.done = 0;
        this.active = 0;
        this.sendState();
    }

    private synchronized void sendState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("jobId", this.jobId);
        state.put("stageId", this.stageId);
        state.put("stageLink", this.stageLink);
        state.put("jobLink", this.jobLink);
        state.put("done", this.done);
        state.put("active", this.active);
        state.put("numberOfTasks", this.numberOfTasks);
        this.sendUpdate("state", state);
    }

    public void hide() {
        this.sendUpdate("hide", true);
    }
}

