/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.InstructionKey;
import org.jetbrains.kotlin.gnu.trove.TIntObjectHashMap;

class InstructionKeySet {
    @NotNull
    private final Node myRoot;

    InstructionKeySet(int initialCapacity) {
        this.myRoot = new Node(initialCapacity);
    }

    void add(@NotNull InstructionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKeySet", "add"));
        }
        this.myRoot.add(key.getOffset(), key.getCallStack(), 0);
    }

    boolean contains(@NotNull InstructionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKeySet", "contains"));
        }
        return this.myRoot.contains(key.getOffset(), key.getCallStack(), 0);
    }

    public String toString() {
        return this.myRoot.toString();
    }

    private static class Node
    extends TIntObjectHashMap<Node> {
        private Node(int initialCapacity) {
            super(Math.max(initialCapacity, 2));
        }

        private void add(int offset2, @NotNull int[] stack, int level) {
            if (stack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKeySet$Node", "add"));
            }
            if (level < stack.length) {
                Node node = (Node)this.get(offset2);
                if (node == null) {
                    node = new Node(4);
                    this.put(offset2, node);
                }
                node.add(stack[level], stack, level + 1);
            } else if (!this.containsKey(offset2)) {
                this.put(offset2, null);
            }
        }

        private boolean contains(int offset2, @NotNull int[] stack, int level) {
            Node node;
            if (stack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKeySet$Node", "contains"));
            }
            if (level < stack.length && (node = (Node)this.get(offset2)) != null) {
                return node.contains(stack[level], stack, level + 1);
            }
            return this.containsKey(offset2);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            int[] offsets = this.keys();
            Arrays.sort(offsets);
            for (int offset2 : offsets) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(offset2);
                Node node = (Node)this.get(offset2);
                if (node == null) continue;
                sb.append(node);
            }
            return sb.append("}").toString();
        }
    }
}

