/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.SingleSparkSession;
import com.twosigma.beakerx.widget.SparkEngineImpl;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUiDefaultsImpl;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkMagicCommand
implements MagicCommandFunctionality {
    public static final String SPARK = "%%sparkRunner";
    public static final SingleSparkSession SINGLE_SPARK_SESSION = new SingleSparkSessionImpl();
    private KernelFunctionality kernel;
    private SparkUI.SparkUIFactory sparkUIFactory;
    private Map<String, SparkOption> sparkOptions;

    public SparkMagicCommand(KernelFunctionality kernel) {
        this(kernel, new SparkUI.SparkUIFactoryImpl(new SparkEngineImpl.SparkEngineFactoryImpl(), new SparkUiDefaultsImpl(Paths.get((System.getenv("JUPYTER_CONFIG_DIR") != null ? System.getenv("JUPYTER_CONFIG_DIR") : System.getProperty("user.home") + File.separator + ".jupyter") + File.separator + "beakerx.json", new String[0])), SINGLE_SPARK_SESSION));
    }

    SparkMagicCommand(KernelFunctionality kernel, SparkUI.SparkUIFactory sparkUIFactory) {
        this.kernel = kernel;
        this.sparkUIFactory = sparkUIFactory;
        this.configureOptions();
    }

    private void configureOptions() {
        this.sparkOptions = new HashMap<String, SparkOption>();
        this.sparkOptions.put("--connect", this::connectToSparkSession);
        this.sparkOptions.put("-c", this::connectToSparkSession);
    }

    public String getMagicCommandName() {
        return SPARK;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        List<String> options = this.getOptions(param);
        MagicCommandOutcomeItem optionValidation = this.validateOptions(options);
        if (optionValidation.getStatus().equals((Object)MagicCommandOutcomeItem.Status.ERROR)) {
            return optionValidation;
        }
        return this.createUI(param, options);
    }

    private MagicCommandOutcomeItem createUI(MagicCommandExecutionParam param, List<String> options) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)param.getCommandCodeBlock(), (KernelFunctionality)this.kernel, (Message)param.getCode().getMessage(), (int)param.getExecutionCount());
        if (param.getCommandCodeBlock().isEmpty()) {
            return this.createSparkUiBasedOnEmptyConfiguration(param, options, seo);
        }
        return this.createSparkUIBasedOnUserSparkConfiguration(param, options, seo);
    }

    private MagicCommandOutcomeItem createSparkUiBasedOnEmptyConfiguration(MagicCommandExecutionParam param, List<String> options, SimpleEvaluationObject seo) {
        InternalVariable.setValue((SimpleEvaluationObject)seo);
        SparkSession.Builder config = SparkSession.builder().config(new SparkConf());
        this.createSparkUI(config, param.getCode().getMessage(), options);
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private MagicCommandOutcomeItem createSparkUIBasedOnUserSparkConfiguration(MagicCommandExecutionParam param, List<String> options, SimpleEvaluationObject seo) {
        TryResult either = this.kernel.executeCode(param.getCommandCodeBlock(), seo);
        if (either.isResult()) {
            Object result = either.result();
            if (result instanceof SparkConf) {
                SparkSession.Builder config = SparkSession.builder().config((SparkConf)result);
                this.createSparkUI(config, param.getCode().getMessage(), options);
            } else if (result instanceof SparkSession.Builder) {
                SparkSession.Builder config = (SparkSession.Builder)result;
                this.createSparkUI(config, param.getCode().getMessage(), options);
            } else {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Body of  %%sparkRunner magic command must return SparkConf object or SparkSession.Builder object");
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %%sparkRunner : " + either.error());
    }

    private SparkUI createSparkUI(SparkSession.Builder builder, Message message, List<String> options) {
        SparkUI sparkUI = this.sparkUIFactory.create(builder);
        return this.displaySparkUI(sparkUI, message, options);
    }

    private SparkUI displaySparkUI(SparkUI sparkUI, Message message, List<String> options) {
        Display.display((Object)sparkUI);
        options.forEach(option -> this.sparkOptions.get(option).run(sparkUI, message));
        return sparkUI;
    }

    private MagicCommandOutcomeItem validateOptions(List<String> options) {
        for (String option : options) {
            if (this.sparkOptions.containsKey(option)) continue;
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Unknown option " + option);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private List<String> getOptions(MagicCommandExecutionParam param) {
        String[] parts = param.getCommand().split(" ");
        if (parts.length == 1) {
            return new ArrayList<String>();
        }
        return Arrays.asList(Arrays.copyOfRange(parts, 1, parts.length));
    }

    private void connectToSparkSession(SparkUI sparkUI, Message parent) {
        sparkUI.getConnectButton().onClick(new HashMap(), parent);
    }

    public static class SingleSparkSessionImpl
    implements SingleSparkSession {
        private boolean active = false;

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void active() {
            this.active = true;
        }

        @Override
        public void inActive() {
            this.active = false;
        }
    }

    static interface SparkOption {
        public void run(SparkUI var1, Message var2);
    }
}

