/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ErrorData;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;

public class ClasspathAddJarMagicCommand
extends ClasspathMagicCommand {
    private static final String ADD = "add";
    private static final String JAR = "jar";
    public static final String CLASSPATH_ADD_JAR = "%classpath add jar";

    public ClasspathAddJarMagicCommand(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_ADD_JAR;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 2 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(JAR);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length != 4) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath add jar");
        }
        String path = split[3];
        return this.addJar(path);
    }

    public MagicCommandOutcomeItem addJar(String path) {
        ErrorData errorData = this.isValidPath(path);
        if (errorData.hasError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, errorData.getMessage());
        }
        return this.handleAddedJars(path);
    }
}

