/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.BeakerxDefaultDisplayers;
import com.twosigma.beakerx.DisplayerDataMapper;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.evaluator.Hook;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.inspect.InspectResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.AddImportStatus;
import com.twosigma.beakerx.kernel.CacheFolderFactory;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.CloseKernelAction;
import com.twosigma.beakerx.kernel.CustomMagicCommandsFactory;
import com.twosigma.beakerx.kernel.EnvCacheFolderFactory;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelHandlers;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.KernelSignalHandler;
import com.twosigma.beakerx.kernel.KernelSockets;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.MagicKernelManager;
import com.twosigma.beakerx.kernel.NoSuchKernelException;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.PythonEntryPoint;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandTypesFactory;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.kernel.threads.ExecutionResultSender;
import com.twosigma.beakerx.message.Message;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Kernel
implements KernelFunctionality {
    private static final Logger logger = LoggerFactory.getLogger(Kernel.class);
    private static String OS = System.getProperty("os.name").toLowerCase();
    public static boolean showNullExecutionResult = true;
    private final CloseKernelAction closeKernelAction;
    private String sessionId;
    private KernelSocketsFactory kernelSocketsFactory;
    private KernelHandlers handlers;
    private Map<String, Comm> commMap;
    private ExecutionResultSender executionResultSender;
    private Evaluator evaluator;
    private KernelSockets kernelSockets;
    private List<MagicCommandType> magicCommandTypes;
    private CacheFolderFactory cacheFolderFactory;
    private CustomMagicCommandsFactory customMagicCommands;
    private Map<String, MagicKernelManager> magicKernels;
    private Map<String, String> commKernelMapping;

    public Kernel(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CustomMagicCommandsFactory customMagicCommands) {
        this(sessionId, evaluator, kernelSocketsFactory, () -> System.exit(0), new EnvCacheFolderFactory(), customMagicCommands);
    }

    protected Kernel(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CloseKernelAction closeKernelAction, CacheFolderFactory cacheFolderFactory, CustomMagicCommandsFactory customMagicCommands) {
        this.sessionId = sessionId;
        this.cacheFolderFactory = cacheFolderFactory;
        this.kernelSocketsFactory = kernelSocketsFactory;
        this.closeKernelAction = closeKernelAction;
        this.customMagicCommands = customMagicCommands;
        this.commMap = new ConcurrentHashMap<String, Comm>();
        this.executionResultSender = new ExecutionResultSender(this);
        this.evaluator = evaluator;
        this.handlers = new KernelHandlers(this, this.getCommOpenHandler(this), this.getKernelInfoHandler(this));
        this.magicKernels = new HashMap<String, MagicKernelManager>();
        this.commKernelMapping = new HashMap<String, String>();
        this.createMagicCommands();
        DisplayerDataMapper.init();
        this.configureSignalHandler();
        this.initJvmRepr();
    }

    public abstract CommOpenHandler getCommOpenHandler(Kernel var1);

    public abstract KernelHandler<Message> getKernelInfoHandler(Kernel var1);

    @Override
    public void run() {
        KernelManager.register(this);
        logger.debug("Jupyter kernel starting.");
        this.kernelSockets = this.kernelSocketsFactory.create(this, this::closeComms);
        this.kernelSockets.start();
        try {
            this.kernelSockets.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.doExit();
            logger.debug("Jupyter kernel shoutdown.");
        }
    }

    private void doExit() {
        this.doExitOnKernelManager();
        this.evaluator.exit();
        this.handlers.exit();
        this.executionResultSender.exit();
        this.closeKernelAction.close();
    }

    private void doExitOnKernelManager() {
        for (MagicKernelManager manager : this.magicKernels.values()) {
            manager.exit();
        }
    }

    private void closeComms() {
        this.commMap.values().forEach(Comm::close);
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    @Override
    public synchronized void updateEvaluatorParameters(EvaluatorParameters kernelParameters) {
        this.evaluator.updateEvaluatorParameters(kernelParameters);
    }

    @Override
    public synchronized void cancelExecution() {
        this.evaluator.cancelExecution();
    }

    @Override
    public synchronized boolean isCommPresent(String hash) {
        return this.commMap.containsKey(hash);
    }

    @Override
    public Set<String> getCommHashSet() {
        return this.commMap.keySet();
    }

    @Override
    public synchronized void addComm(String hash, Comm commObject) {
        if (!this.isCommPresent(hash)) {
            this.commMap.put(hash, commObject);
        }
    }

    @Override
    public synchronized Comm getComm(String hash) {
        return this.commMap.get(hash != null ? hash : "");
    }

    @Override
    public synchronized void removeComm(String hash) {
        if (hash != null && this.isCommPresent(hash)) {
            this.commMap.remove(hash);
        }
    }

    @Override
    public synchronized void publish(List<Message> message) {
        this.kernelSockets.publish(message);
    }

    @Override
    public synchronized void send(Message message) {
        this.kernelSockets.send(message);
    }

    @Override
    public Handler<Message> getHandler(JupyterMessages type) {
        return this.handlers.get(type);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public ExecutionResultSender getExecutionResultSender() {
        return this.executionResultSender;
    }

    private void configureSignalHandler() {
        if (!Kernel.isWindows()) {
            KernelSignalHandler.addSigIntHandler(this::cancelExecution);
        }
    }

    @Override
    public TryResult executeCode(String code, SimpleEvaluationObject seo) {
        return this.evaluator.evaluate(seo, code);
    }

    @Override
    public AutocompleteResult autocomplete(String code, int cursorPos) {
        return this.evaluator.autocomplete(code, cursorPos);
    }

    @Override
    public InspectResult inspect(String code, int cursorPos) {
        return this.evaluator.inspect(code, cursorPos);
    }

    @Override
    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        return this.evaluator.addJarsToClasspath(paths);
    }

    @Override
    public void sendBusyMessage(Message message) {
        this.publish(Collections.singletonList(MessageCreator.createBusyMessage(message)));
    }

    @Override
    public void sendIdleMessage(Message message) {
        this.publish(Collections.singletonList(MessageCreator.createIdleMessage(message)));
    }

    @Override
    public Classpath getClasspath() {
        return this.evaluator.getClasspath();
    }

    @Override
    public Imports getImports() {
        return this.evaluator.getImports();
    }

    @Override
    public AddImportStatus addImport(ImportPath anImport) {
        return this.evaluator.addImport(anImport);
    }

    @Override
    public void removeImport(ImportPath anImport) {
        this.evaluator.removeImport(anImport);
    }

    @Override
    public Path getTempFolder() {
        return this.evaluator.getTempFolder();
    }

    @Override
    public Path getCacheFolder() {
        return this.cacheFolderFactory.getCache();
    }

    @Override
    public Class<?> loadClass(String clazzName) throws ClassNotFoundException {
        return this.evaluator.loadClass(clazzName);
    }

    @Override
    public List<MagicCommandType> getMagicCommandTypes() {
        return new ArrayList<MagicCommandType>(this.magicCommandTypes);
    }

    private void createMagicCommands() {
        this.magicCommandTypes = MagicCommandTypesFactory.createDefaults(this);
        this.customMagicCommands.customMagicCommands(this).forEach(this::registerMagicCommandType);
        this.configureMagicCommands();
    }

    protected void configureMagicCommands() {
    }

    @Override
    public void registerMagicCommandType(MagicCommandType magicCommandType) {
        this.magicCommandTypes.add(magicCommandType);
    }

    private void initJvmRepr() {
        BeakerxDefaultDisplayers.registerDefaults();
        this.configureJvmRepr();
    }

    protected void configureJvmRepr() {
    }

    @Override
    public String getOutDir() {
        return this.evaluator.getOutDir();
    }

    @Override
    public void registerCancelHook(Hook hook) {
        this.evaluator.registerCancelHook(hook);
    }

    @Override
    public PythonEntryPoint getPythonEntryPoint(String kernelName) throws NoSuchKernelException {
        MagicKernelManager manager = this.magicKernels.get(kernelName);
        if (manager == null) {
            manager = new MagicKernelManager(kernelName);
            this.magicKernels.put(kernelName, manager);
        }
        return manager.getPythonEntryPoint();
    }

    @Override
    public MagicKernelManager getManagerByCommId(String commId) {
        String kernelName = this.commKernelMapping.get(commId);
        return this.magicKernels.get(kernelName);
    }

    @Override
    public void addCommIdManagerMapping(String commId, String kernel) {
        this.commKernelMapping.put(commId, kernel);
    }
}

