/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.SmartFMap;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageHandler;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;

public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages;
    private MessageHandler myDefaultHandler;
    private volatile SmartFMap<Topic, Object> mySubscriptions;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "<init>"));
        }
        this.myPendingMessages = MessageBusImpl.createThreadLocalQueue();
        this.mySubscriptions = SmartFMap.emptyMap();
        this.myBus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler2) throws IllegalStateException {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "subscribe"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "subscribe"));
        }
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            if (this.mySubscriptions.get(topic) != null) {
                throw new IllegalStateException("Subscription to " + topic + " already exists");
            }
            this.mySubscriptions = this.mySubscriptions.plus(topic, handler2);
        }
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public void dispose() {
        Queue<Message> jobs = this.myPendingMessages.get();
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
    }

    @Override
    public void disconnect() {
        Disposer.dispose(this);
    }

    @Override
    public void deliverImmediately() {
        Queue<Message> messages = this.myPendingMessages.get();
        while (!messages.isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(@NotNull Message message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "deliverMessage"));
        }
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler2 = this.mySubscriptions.get(topic);
        try {
            Method listenerMethod = message.getListenerMethod();
            if (handler2 == this.myDefaultHandler) {
                this.myDefaultHandler.handle(listenerMethod, message.getArgs());
            } else {
                listenerMethod.invoke(handler2, message.getArgs());
            }
        }
        catch (AbstractMethodError listenerMethod) {
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
        catch (Throwable e) {
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
    }

    void scheduleMessageDelivery(@NotNull Message message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "scheduleMessageDelivery"));
        }
        this.myPendingMessages.get().offer(message);
    }

    public String toString() {
        return this.mySubscriptions.toString();
    }

    @NotNull
    MessageBusImpl getBus() {
        MessageBusImpl messageBusImpl = this.myBus;
        if (messageBusImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl", "getBus"));
        }
        return messageBusImpl;
    }
}

