/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.twosigma.beakerx.widget.SparkEngineImpl;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkUiDefaultsImpl
implements SparkUiDefaults {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String PROPERTIES = "properties";
    public static final String SPARK_OPTIONS = "spark_options";
    public static final String BEAKERX = "beakerx";
    private static final String SPARK_PROFILES = "profiles";
    private static final String CURRENT_PROFILE = "current_profile";
    private List<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Path path;
    private String currentProfile = "";

    public SparkUiDefaultsImpl(Path path) {
        this.path = path;
    }

    @Override
    public void saveSparkConf(List<Map<String, Object>> profiles) {
        try {
            Map<String, Map> map = this.beakerxJsonAsMap(this.path);
            Map sparkOptions = map.get(BEAKERX).getOrDefault(SPARK_OPTIONS, new HashMap());
            sparkOptions.put(SPARK_PROFILES, profiles == null ? new ArrayList<Map<String, Object>>() : profiles);
            map.get(BEAKERX).put(SPARK_OPTIONS, sparkOptions);
            String content = this.gson.toJson(map);
            Files.write(this.path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.profiles = profiles;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadDefaults(SparkSession.Builder builder) {
        SparkConf sparkConf = SparkEngineImpl.getSparkConfBasedOn(builder);
        this.loadProfiles();
        Map<String, Object> map = this.getProfileByName(this.currentProfile);
        if (map != null) {
            map.entrySet().stream().filter(x -> !sparkConf.contains((String)x.getKey())).forEach(x -> this.addToBuilder(builder, (String)x.getKey(), x.getValue()));
        }
    }

    @Override
    public List<Map<String, Object>> getProfiles() {
        return this.profiles;
    }

    @Override
    public Map<String, Object> getProfileByName(String name) {
        HashMap profile = new HashMap();
        return this.profiles.stream().filter(x -> x.get(NAME).equals(name)).findFirst().orElse(profile);
    }

    @Override
    public void loadProfiles() {
        Map<String, Map> beakerxJson = this.beakerxJsonAsMap(this.path);
        Map sparkOptions = beakerxJson.get(BEAKERX).getOrDefault(SPARK_OPTIONS, new HashMap());
        List profiles = (List)sparkOptions.get(SPARK_PROFILES);
        this.currentProfile = sparkOptions.getOrDefault(CURRENT_PROFILE, "");
        if (profiles == null) {
            HashMap<String, Object> defaultProfile = new HashMap<String, Object>();
            defaultProfile.put(NAME, "");
            defaultProfile.put("spark.master", "local[*]");
            defaultProfile.put("spark.executor.cores", "10");
            defaultProfile.put("spark.executor.memory", "8g");
            defaultProfile.put(PROPERTIES, new ArrayList());
            this.saveProfile(defaultProfile);
        } else {
            this.profiles = profiles;
        }
    }

    @Override
    public void saveProfile(Map<String, Object> profile) {
        int idx = IntStream.range(0, this.profiles.size()).filter(i -> profile.get(NAME).equals(this.profiles.get(i).get(NAME))).findFirst().orElse(-1);
        if (idx == -1) {
            this.profiles.add(profile);
        } else {
            this.profiles.set(idx, profile);
        }
        this.saveSparkConf(this.profiles);
    }

    @Override
    public List<String> getProfileNames() {
        return this.profiles.stream().map(x -> (String)x.get(NAME)).collect(Collectors.toList());
    }

    @Override
    public void saveProfileName(String profileName) {
        try {
            Map<String, Map> map = this.beakerxJsonAsMap(this.path);
            Map sparkOptions = map.get(BEAKERX).getOrDefault(SPARK_OPTIONS, new HashMap());
            sparkOptions.put(CURRENT_PROFILE, profileName);
            map.get(BEAKERX).put(SPARK_OPTIONS, sparkOptions);
            String content = this.gson.toJson(map);
            Files.write(this.path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.currentProfile = profileName;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getCurrentProfileName() {
        return this.currentProfile;
    }

    @Override
    public void removeSparkConf(String profileName) {
        this.profiles.removeIf(x -> x.get(NAME).equals(profileName));
        this.saveSparkConf(this.profiles);
    }

    private void addToBuilder(SparkSession.Builder builder, String key, Object value) {
        if (this.isOneOfMainProp(key)) {
            builder.config(key, (String)value);
        } else if (key.equals(PROPERTIES)) {
            List props = (List)value;
            props.forEach(x -> builder.config((String)x.get(NAME), (String)x.get(VALUE)));
        }
    }

    private Map<String, Object> getOptions(Map<String, Map> beakerxJson) {
        return (Map)beakerxJson.get(BEAKERX).get(SPARK_OPTIONS);
    }

    private boolean isOneOfMainProp(String key) {
        return key.equals("spark.master") || key.equals("spark.executor.memory") || key.equals("spark.executor.cores");
    }

    Map<String, Map> beakerxJsonAsMap(Path path) {
        String jsonAsString = null;
        try {
            jsonAsString = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Map)this.gson.fromJson(jsonAsString, Map.class);
    }

    private Map<String, Object> toMap(SparkConf sparkConf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Arrays.stream(sparkConf.getAll()).filter(x -> !((String)x._1).equals("spark.extraListeners")).filter(x -> !((String)x._1).equals("beakerx.id")).filter(x -> !((String)x._1).equals("spark.app.name")).forEach(x -> this.addToMap(result, (Tuple2<String, String>)x));
        return result;
    }

    private void addToMap(Map<String, Object> result, Tuple2<String, String> x) {
        if (this.isOneOfMainProp((String)x._1)) {
            result.put((String)x._1, x._2);
        } else {
            List<Map<String, String>> props = this.getProps(result);
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put(NAME, x._1);
            e.put(VALUE, x._2);
            props.add(e);
        }
    }

    private List<Map<String, String>> getProps(Map<String, Object> result) {
        Object propsAsObject = result.get(PROPERTIES);
        if (propsAsObject == null) {
            ArrayList<Map<String, String>> props = new ArrayList<Map<String, String>>();
            result.put(PROPERTIES, props);
            return props;
        }
        return (List)propsAsObject;
    }
}

