/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.autocomplete.db;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.sql.BeakerParser;
import com.twosigma.beakerx.sql.ConnectionStringHolder;
import com.twosigma.beakerx.sql.DBConnectionException;
import com.twosigma.beakerx.sql.JDBCClient;
import com.twosigma.beakerx.sql.autocomplete.db.DbCache;
import com.twosigma.beakerx.sql.autocomplete.db.DbInfo;
import com.twosigma.beakerx.sql.autocomplete.db.DbRequestCache;
import com.twosigma.beakerx.sql.autocomplete.db.MysqlDbExplorer;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbExplorerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DbExplorerFactory.class);
    private static final String VENDOR_JDBC_MYSQL = "jdbc:mysql:";

    public static DbInfo getDbInfo(String txt, JDBCClient jdbcClient, String sessionId, ConnectionStringHolder defaultConnectionString, Map<String, ConnectionStringHolder> namedConnectionString) {
        NamespaceClient namespaceClient = NamespaceClient.getBeaker((String)sessionId);
        try {
            BeakerParser beakerParser = new BeakerParser(txt, namespaceClient, defaultConnectionString, namedConnectionString, jdbcClient);
            String uri = beakerParser.getDbURI().getActualConnectionString();
            if (uri != null) {
                BasicDataSource ds = jdbcClient.getDataSource(uri);
                if (uri.startsWith(VENDOR_JDBC_MYSQL)) {
                    return new MysqlDbExplorer((DataSource)ds);
                }
            }
        }
        catch (DBConnectionException | IOException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public static DbCache getDbCache() {
        return new DbRequestCache();
    }
}

