/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MIMEDisplayMethodManager {
    private static MIMEDisplayMethodManager instance = new MIMEDisplayMethodManager();
    private Display.MIMEContainerDisplayMethodStrategy defaultDisplayMimeMethodStrategy;
    private Display.MIMEContainerDisplayMethodStrategy displayMimeMethodStrategy;

    private MIMEDisplayMethodManager() {
        this.displayMimeMethodStrategy = this.defaultDisplayMimeMethodStrategy = new DefaultMIMEContainerDisplayMethodStrategy();
    }

    public static MIMEDisplayMethodManager getInstance() {
        return instance;
    }

    public void display(List<MIMEContainer> mimeContainers) {
        this.displayMimeMethodStrategy.display(mimeContainers);
    }

    public void setDefaultDisplayMethod() {
        this.displayMimeMethodStrategy = this.defaultDisplayMimeMethodStrategy;
    }

    public void defineDisplayMethod(Display.MIMEContainerDisplayMethodStrategy mimeContainerDisplayMethodStrategy) {
        this.displayMimeMethodStrategy = mimeContainerDisplayMethodStrategy;
    }

    public static class DefaultMIMEContainerDisplayMethodStrategy
    implements Display.MIMEContainerDisplayMethodStrategy {
        @Override
        public void display(List<MIMEContainer> mimeContainers) {
            HashMap<String, Serializable> content = new HashMap<String, Serializable>();
            HashMap data = new HashMap();
            mimeContainers.forEach(x -> data.put(x.getMime().asString(), x.getData()));
            content.put("data", data);
            content.put("metadata", new HashMap());
            Message message = Comm.messageMessage(JupyterMessages.DISPLAY_DATA, Comm.Buffer.EMPTY, content, InternalVariable.getParentHeader());
            KernelManager.get().publish(Collections.singletonList(message));
        }
    }
}

