/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.BxHTML;
import java.math.BigDecimal;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class MvnLoggerWidget {
    static final int PERIOD = 250;
    public static final String DOWNLOADED = "Downloaded";
    private BxHTML widget;
    private Timer timer;
    private volatile int jarNumbers = 0;
    private volatile double sizeInKb;
    private volatile String speed;
    private volatile String currentLine;

    public MvnLoggerWidget(Message parentMessage) {
        this.widget = new BxHTML(parentMessage);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (MvnLoggerWidget.this.jarNumbers > 0) {
                    String sizeWithUnit = FileUtils.byteCountToDisplaySize((long)new Double(MvnLoggerWidget.this.sizeInKb * 1000.0).longValue());
                    String status = String.format("%d jar%s, %s downloaded at %s", MvnLoggerWidget.this.jarNumbers, MvnLoggerWidget.this.getPluralFormWhenNumberOfJarGreaterThanOne(), sizeWithUnit, MvnLoggerWidget.this.speed);
                    MvnLoggerWidget.this.widget.setValue(status + "</br>" + MvnLoggerWidget.this.formatCurrentLine());
                }
            }
        }, 0L, 250L);
    }

    private String formatCurrentLine() {
        return this.currentLine.replaceFirst(DOWNLOADED, "").trim().replaceFirst(":", "").trim();
    }

    private String getPluralFormWhenNumberOfJarGreaterThanOne() {
        return this.jarNumbers > 1 ? "s" : "";
    }

    public void sendLog(String line) {
        if (line != null && !line.trim().isEmpty() && line.matches("Downloaded.+")) {
            this.currentLine = line;
            if (line.matches(".+jar.+")) {
                ++this.jarNumbers;
                String[] info = this.split(line);
                if (info.length == 5) {
                    this.sizeInKb += this.calculateJarSizeInKb(info);
                    this.speed = this.calculateSpeed(info);
                }
            }
        }
    }

    private String calculateSpeed(String[] info) {
        return info[3] + info[4];
    }

    private String[] split(String line) {
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String infoWithBrackets = matcher.group();
            return infoWithBrackets.replace("(", "").replace(")", "").split(" ");
        }
        return new String[0];
    }

    private double calculateJarSizeInKb(String[] info) {
        String unit = info[1];
        if (unit.toLowerCase().equals("kb")) {
            return new BigDecimal(info[0]).doubleValue();
        }
        if (unit.toLowerCase().equals("mb")) {
            return new BigDecimal(info[0]).multiply(new BigDecimal("1000")).doubleValue();
        }
        return 0.0;
    }

    public void display() {
        this.widget.display();
    }

    public void close() {
        this.timer.cancel();
        this.widget.close();
    }
}

