/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.msg.StacktraceHtmlPrinter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.Foldout;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.SparkConfiguration;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkFoldout;
import com.twosigma.beakerx.widget.SparkStateProgress;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUIForm;
import com.twosigma.beakerx.widget.SparkUIStatus;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.SparkVariable;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkUI
extends VBox
implements SparkUIApi {
    public static final String ONE_SPARK_SESSION_MSG_ERROR = "Cannot have more than one Spark session open in the same notebook.";
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    public static final String SPARK_MASTER_DEFAULT = "local[*]";
    private static final String SPARK_APP_ID = "sparkAppId";
    public static final String ERROR_CREATING_SPARK_SESSION = "Error creating SparkSession, see the console log for more explanation";
    private static volatile boolean active = false;
    private final SparkUIForm sparkUIForm;
    private VBox sparkUIFormPanel;
    private HBox statusPanel;
    private Map<Integer, SparkStateProgress> progressBarMap = new HashMap<Integer, SparkStateProgress>();
    private SparkFoldout jobPanel = null;
    private Message currentParentHeader = null;
    private SparkEngine sparkEngine;
    private SparkUiDefaults sparkUiDefaults;

    SparkUI(SparkSession.Builder builder, SparkEngine.SparkEngineFactory sparkEngineFactory, SparkUiDefaults sparkUiDefaults) {
        super(new ArrayList());
        this.sparkUiDefaults = sparkUiDefaults;
        this.sparkUiDefaults.loadDefaults(builder);
        this.sparkEngine = sparkEngineFactory.create(builder);
        this.sparkUIFormPanel = new VBox(new ArrayList());
        this.add((Widget)this.sparkUIFormPanel);
        SparkVariable.putSparkUI(this);
        this.sparkUIForm = new SparkUIForm(this.sparkEngine, this::initSparkContext);
        this.sparkUIFormPanel.add((Widget)this.sparkUIForm);
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    @Override
    public void startSpinner(Message parentMessage) {
        this.sparkUIForm.startSpinner(parentMessage);
    }

    @Override
    public void stopSpinner() {
        this.sparkUIForm.stopSpinner();
    }

    private void initSparkContext(Message parentMessage) {
        this.sparkUIForm.clearErrors();
        KernelFunctionality kernel = KernelManager.get();
        if (SparkUI.isActive()) {
            this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)ONE_SPARK_SESSION_MSG_ERROR));
        } else {
            SparkVariable.putSparkUI(this);
            this.configureSparkContext(parentMessage, kernel);
        }
    }

    private void configureSparkContext(Message parentMessage, KernelFunctionality kernel) {
        try {
            TryResult configure = this.sparkEngine.configure(kernel, this, parentMessage);
            if (configure.isError()) {
                this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)ERROR_CREATING_SPARK_SESSION));
            } else {
                SparkUI.active();
                this.saveSparkConf(this.sparkEngine.getSparkConf());
                this.applicationStart();
            }
        }
        catch (Exception e) {
            this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)e.getMessage()));
        }
    }

    private SparkSession getSparkSession() {
        return this.sparkEngine.getOrCreate();
    }

    private void applicationStart() {
        this.clearSparkUIFormPanel();
        this.statusPanel = new SparkUIStatus(message -> this.getSparkSession().sparkContext().stop());
        this.add((Widget)this.statusPanel);
        this.sendUpdate(SPARK_APP_ID, this.sparkEngine.getSparkAppId());
        this.sendUpdate("sparkUiWebUrl", this.sparkEngine.getSparkUiWebUrl());
        this.sendUpdate("sparkMasterUrl", this.sparkEngine.getSparkMasterUrl());
    }

    @Override
    public void applicationEnd() {
        this.removeStatusPanel();
        SparkUI.inActive();
        this.addSparkUIFormPanel();
    }

    private void removeStatusPanel() {
        if (this.statusPanel != null) {
            this.remove((Widget)this.statusPanel);
            this.statusPanel = null;
        }
    }

    @Override
    public void startStage(int stageId, int numTasks) {
        if (this.isStartStageFromNewCell()) {
            this.jobPanel = this.createSparkFoldout(this.jobPanel);
        }
        SparkStateProgress intProgress = new SparkStateProgress(numTasks, stageId, stageId, this.jobLink(stageId), this.stageLink(stageId));
        intProgress.init();
        this.jobPanel.add((Widget)intProgress);
        this.progressBarMap.put(stageId, intProgress);
    }

    private boolean isStartStageFromNewCell() {
        return InternalVariable.getParentHeader() != this.currentParentHeader;
    }

    private SparkFoldout createSparkFoldout(SparkFoldout oldJobPanel) {
        this.currentParentHeader = InternalVariable.getParentHeader();
        if (oldJobPanel != null) {
            oldJobPanel.getLayout().setDisplayNone();
            oldJobPanel.close();
        }
        Foldout.FoldoutOption foldoutOption = new Foldout.FoldoutOption();
        foldoutOption.headerLabel = "Spark progress";
        SparkFoldout jobPanel = new SparkFoldout(new ArrayList(), foldoutOption);
        jobPanel.display();
        return jobPanel;
    }

    @Override
    public void endStage(int stageId) {
        SparkStateProgress sparkStateProgress = this.progressBarMap.get(stageId);
        sparkStateProgress.hide();
    }

    @Override
    public void taskStart(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBarMap.get(stageId);
        intProgress.addActive();
    }

    @Override
    public void taskEnd(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBarMap.get(stageId);
        intProgress.addDone();
    }

    private String stageLink(int stageId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
        }
        return "";
    }

    private String jobLink(int jobId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
        }
        return "";
    }

    @Override
    public void cancelAllJobs() {
        this.getSparkSession().sparkContext().cancelAllJobs();
    }

    @Override
    public Text getMasterURL() {
        return this.sparkUIForm.getMasterURL();
    }

    @Override
    public Text getExecutorMemory() {
        return this.sparkUIForm.getExecutorMemory();
    }

    @Override
    public Text getExecutorCores() {
        return this.sparkUIForm.getExecutorCores();
    }

    @Override
    public List<SparkConfiguration.Configuration> getAdvancedOptions() {
        return this.sparkUIForm.getAdvancedOptions();
    }

    private void clearSparkUIFormPanel() {
        if (this.sparkUIFormPanel != null) {
            this.remove((Widget)this.sparkUIFormPanel);
            this.sparkUIFormPanel = null;
        }
    }

    private void addSparkUIFormPanel() {
        if (this.sparkUIFormPanel == null) {
            this.sparkUIFormPanel = new VBox(Arrays.asList(new Widget[]{this.sparkUIForm}));
            this.add((Widget)this.sparkUIFormPanel);
        }
    }

    public Button getConnectButton() {
        return this.sparkUIForm.getConnectButton();
    }

    void saveSparkConf(SparkConf sparkConf) {
        this.sparkUiDefaults.saveSparkConf(sparkConf);
    }

    public static boolean isActive() {
        return active;
    }

    public static void active() {
        active = true;
    }

    public static void inActive() {
        active = false;
    }

    @FunctionalInterface
    public static interface OnSparkButtonAction {
        public void run(Message var1);
    }

    public static class SparkUIFactoryImpl
    implements SparkUIFactory {
        SparkEngine.SparkEngineFactory sparkEngineFactory;
        SparkUiDefaults sparkUiDefaults;

        public SparkUIFactoryImpl(SparkEngine.SparkEngineFactory sparkEngineFactory, SparkUiDefaults sparkUiDefaults) {
            this.sparkEngineFactory = sparkEngineFactory;
            this.sparkUiDefaults = sparkUiDefaults;
        }

        @Override
        public SparkUI create(SparkSession.Builder builder) {
            return new SparkUI(builder, this.sparkEngineFactory, this.sparkUiDefaults);
        }
    }

    public static interface SparkUIFactory {
        public SparkUI create(SparkSession.Builder var1);
    }
}

