/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.BxHTML;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.SparkConfiguration;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.Spinner;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkConf;

public class SparkUIForm
extends VBox {
    static final String CONNECT = "Start";
    private HBox errors;
    private Text masterURL;
    private Text executorMemory;
    private Text executorCores;
    private SparkConfiguration advancedOption;
    private SparkEngine sparkEngine;
    private SparkUI.OnSparkButtonAction onStartAction;
    private Button connectButton;
    private Spinner spinner;
    private HBox spinnerPanel;

    public SparkUIForm(SparkEngine sparkEngine, SparkUI.OnSparkButtonAction onStartAction) {
        super(new ArrayList());
        this.sparkEngine = sparkEngine;
        this.onStartAction = onStartAction;
        this.createSparkView();
    }

    private void createSparkView() {
        this.masterURL = this.createMasterURL();
        this.executorMemory = this.createExecutorMemory();
        this.executorCores = this.createExecutorCores();
        this.errors = new HBox(new ArrayList());
        this.errors.setDomClasses(Arrays.asList("bx-spark-connect-error"));
        this.addConnectButton(this.createConnectButton(), this.errors);
        this.add((Widget)this.masterURL);
        this.add((Widget)this.executorCores);
        this.add((Widget)this.executorMemory);
        this.advancedOption = new SparkConfiguration(this.sparkEngine.getAdvanceSettings(), this.sparkEngine.sparkVersion());
        this.add((Widget)this.advancedOption);
    }

    private void addConnectButton(Button connect, HBox errors) {
        this.connectButton = connect;
        this.spinnerPanel = new HBox();
        this.add((Widget)new HBox(Arrays.asList(this.connectButton, this.spinnerPanel, errors)));
    }

    public void startSpinner(Message parentMessage) {
        this.spinner = new Spinner(parentMessage, "Connecting to " + (String)((Object)this.masterURL.getValue()));
        this.spinnerPanel.add((Widget)this.spinner, parentMessage);
    }

    public void stopSpinner() {
        this.spinnerPanel.remove((Widget)this.spinner);
    }

    private SparkConf getSparkConf() {
        return this.sparkEngine.getSparkConf();
    }

    private Text createMasterURL() {
        Text masterURL = new Text();
        masterURL.setDescription((Object)"Master URL");
        masterURL.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-master-url")));
        if (this.getSparkConf().contains("spark.master")) {
            masterURL.setValue((Object)this.getSparkConf().get("spark.master"));
        } else {
            masterURL.setValue((Object)"local[*]");
        }
        return masterURL;
    }

    private Button createConnectButton() {
        Button connect = new Button();
        connect.setDescription((Object)CONNECT);
        connect.registerOnClick((content, message) -> this.onStartAction.run(message));
        return connect;
    }

    private Text createExecutorMemory() {
        Text memory = new Text();
        memory.setDescription((Object)"Executor Memory");
        memory.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-memory")));
        if (this.getSparkConf().contains("spark.executor.memory")) {
            memory.setValue((Object)this.getSparkConf().get("spark.executor.memory"));
        } else {
            memory.setValue((Object)"8g");
        }
        return memory;
    }

    private Text createExecutorCores() {
        Text cores = new Text();
        cores.setDescription((Object)"Executor cores");
        cores.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-cores")));
        if (this.getSparkConf().contains("spark.executor.cores")) {
            cores.setValue((Object)this.getSparkConf().get("spark.executor.cores"));
        } else {
            cores.setValue((Object)"10");
        }
        return cores;
    }

    public Text getMasterURL() {
        return this.masterURL;
    }

    public Text getExecutorMemory() {
        return this.executorMemory;
    }

    public Text getExecutorCores() {
        return this.executorCores;
    }

    public List<SparkConfiguration.Configuration> getAdvancedOptions() {
        return this.advancedOption.getConfiguration();
    }

    public void sendError(String message) {
        this.clearErrors();
        BxHTML label = new BxHTML();
        label.setValue((Object)message);
        this.errors.add((Widget)label);
    }

    public void clearErrors() {
        this.errors.removeAllChildren();
    }

    public Button getConnectButton() {
        return this.connectButton;
    }
}

