/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.groovy.evaluator.GroovyEvaluator;
import com.twosigma.beakerx.groovy.evaluator.GroovyStackTracePrettyPrinter;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import groovy.lang.Script;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.StackTraceUtils;

class GroovyCodeRunner
implements Callable<TryResult> {
    public static final String SCRIPT_NAME = "script";
    private GroovyEvaluator groovyEvaluator;
    private final String theCode;
    private final SimpleEvaluationObject theOutput;

    public GroovyCodeRunner(GroovyEvaluator groovyEvaluator, String code, SimpleEvaluationObject out) {
        this.groovyEvaluator = groovyEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TryResult call() {
        TryResult either;
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        String scriptName = SCRIPT_NAME;
        try {
            Object instance;
            Object result = null;
            this.theOutput.setOutputHandler();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.groovyEvaluator.getGroovyClassLoader());
            scriptName = scriptName + System.currentTimeMillis();
            Class parsedClass = this.groovyEvaluator.getGroovyClassLoader().parseClass(this.theCode, scriptName);
            if (this.canBeInstantiated(parsedClass) && (instance = parsedClass.newInstance()) instanceof Script) {
                result = this.runScript((Script)instance);
            }
            either = TryResult.createResult(result);
        }
        catch (Throwable e) {
            either = this.handleError(scriptName, e);
        }
        finally {
            this.theOutput.clrOutputHandler();
            Thread.currentThread().setContextClassLoader(oldld);
        }
        return either;
    }

    private TryResult handleError(String scriptName, Throwable e) {
        TryResult.CellError either;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
            either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceUtils.sanitize((Throwable)e).printStackTrace(pw);
            String value = sw.toString();
            value = GroovyStackTracePrettyPrinter.printStacktrace(scriptName, value);
            either = TryResult.createError((String)value);
        }
        return either;
    }

    private Object runScript(Script script) {
        this.groovyEvaluator.getScriptBinding().setVariable("beakerx", (Object)NamespaceClient.getBeaker((String)this.groovyEvaluator.getSessionId()));
        script.setBinding(this.groovyEvaluator.getScriptBinding());
        return script.run();
    }

    private boolean canBeInstantiated(Class<?> parsedClass) {
        return !parsedClass.isEnum();
    }
}

