/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.groovy.autocomplete.GroovyClasspathScanner;
import java.util.List;

public class AutocompleteRegistryFactory {
    public static AutocompleteRegistry createRegistry(GroovyClasspathScanner cps) {
        AutocompleteRegistry registry = AutocompleteRegistryFactory.create(13);
        for (String pkg : cps.getPackages()) {
            String[] pkgv = pkg.split("\\.");
            AutocompleteCandidate c = new AutocompleteCandidate(0, pkgv);
            registry.addCandidate(c);
            List cls = cps.getClasses(pkg);
            if (cls == null || cls.isEmpty()) continue;
            AutocompleteCandidate l = c = new AutocompleteCandidate(5, pkgv);
            while (l.hasChildren()) {
                l = (AutocompleteCandidate)l.getChildrens().get(0);
            }
            for (String cl : cls) {
                l.addChildren(new AutocompleteCandidate(5, cl));
            }
            registry.addCandidate(c);
        }
        return registry;
    }

    private static AutocompleteRegistry create(int num) {
        AutocompleteRegistry registry = new AutocompleteRegistry(num);
        AutocompleteRegistryFactory.setup(registry);
        return registry;
    }

    private static void setup(AutocompleteRegistry r) {
        AutocompleteCandidate c = new AutocompleteCandidate(7, "package");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "import");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "class");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "enum");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "interface");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "def");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "assert");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "if");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "switch");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "while");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "for");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "try");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "extends");
        r.addCandidate(c);
        c = new AutocompleteCandidate(8, "implements");
        r.addCandidate(c);
        c = new AutocompleteCandidate(11, "extends");
        r.addCandidate(c);
        c = new AutocompleteCandidate(11, "implements");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "any");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "collect");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "each");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "eachWithIndex");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "every");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "create");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "findAll");
        r.addCandidate(c);
        c = new AutocompleteCandidate(9, "findIndexOf");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "int");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "float");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "char");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "byte");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "void");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "boolean");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "short");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "long");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "double");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Boolean");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Byte");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Character");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Double");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Float");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Integer");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Long");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Math");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Number");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Object");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Package");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Process");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "ProcessBuilder");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Runtime");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "RuntimePermission");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "SecurityManager");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Short");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "StackTraceElement");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "StrictMath");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "String");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "StringBuffer");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "StringBuilder");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "System");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Thread");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "ThreadGroup");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Throwable");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "Void");
        r.addCandidate(c);
        c = new AutocompleteCandidate(4, "NamespaceClient");
        r.addCandidate(c);
        c = new AutocompleteCandidate(12, "new");
        r.addCandidate(c);
    }

    public static void setup(ClassUtils cu, AutocompleteRegistry registry) {
        cu.defineClassShortName("Boolean", "java.lang.Boolean");
        cu.defineClassShortName("Byte", "java.lang.Byte");
        cu.defineClassShortName("Character", "java.lang.Character");
        cu.defineClassShortName("Double", "java.lang.Double");
        cu.defineClassShortName("Exception", "java.lang.Exception");
        cu.defineClassShortName("Float", "java.lang.Float");
        cu.defineClassShortName("Integer", "java.lang.Integer");
        cu.defineClassShortName("Long", "java.lang.Long");
        cu.defineClassShortName("Math", "java.lang.Math");
        cu.defineClassShortName("Number", "java.lang.Number");
        cu.defineClassShortName("Object", "java.lang.Object");
        cu.defineClassShortName("Package", "java.lang.Package");
        cu.defineClassShortName("Process", "java.lang.Process");
        cu.defineClassShortName("ProcessBuilder", "java.lang.ProcessBuilder");
        cu.defineClassShortName("Runtime", "java.lang.Runtime");
        cu.defineClassShortName("RuntimePermission", "java.lang.RuntimePermission");
        cu.defineClassShortName("SecurityManager", "java.lang.SecurityManager");
        cu.defineClassShortName("Short", "java.lang.Short");
        cu.defineClassShortName("StackTraceElement", "java.lang.StackTraceElement");
        cu.defineClassShortName("StrictMath", "java.lang.StrictMath");
        cu.defineClassShortName("String", "java.lang.String");
        cu.defineClassShortName("StringBuffer", "java.lang.StringBuffer");
        cu.defineClassShortName("StringBuilder", "java.lang.StringBuilder");
        cu.defineClassShortName("System", "java.lang.System");
        cu.defineClassShortName("Thread", "java.lang.Thread");
        cu.defineClassShortName("ThreadGroup", "java.lang.ThreadGroup");
        cu.defineClassShortName("Throwable", "java.lang.Throwable");
        cu.defineClassShortName("Void", "java.lang.Void");
        cu.defineClassShortName("NamespaceClient", "com.twosigma.beaker.NamespaceClient");
        AutocompleteCandidate c = new AutocompleteCandidate(3, "Boolean");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Byte");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Character");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Double");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Exception");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Float");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Integer");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Long");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Number");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Object");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Package");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Process");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "ProcessBuilder");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Runtime");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "RuntimePermission");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "SecurityManager");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Short");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "StackTraceElement");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "StrictMath");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "String");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "StringBuffer");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "StringBuilder");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "System");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Thread");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "ThreadGroup");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Throwable");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "Void");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "NamespaceClient");
        registry.addCandidate(c);
        c = new AutocompleteCandidate(3, "beaker");
        registry.addCandidate(c);
    }

    public static void addDefaultImports(ClassUtils cu, AutocompleteRegistry registry, List<String> imports, GroovyClasspathScanner cps) {
        for (String imp : imports) {
            if (imp.endsWith(".*")) {
                String st = imp.substring(0, imp.length() - 2);
                String[] txtv = st.split("\\.");
                AutocompleteCandidate c = new AutocompleteCandidate(0, txtv);
                registry.addCandidate(c);
                List cls = cps.getClasses(st);
                if (cls == null) continue;
                c = new AutocompleteCandidate(5, txtv);
                AutocompleteCandidate l = c.findLeaf();
                for (String s : cls) {
                    l.addChildren(new AutocompleteCandidate(6, s));
                    registry.addCandidate(new AutocompleteCandidate(6, s));
                    cu.defineClassShortName(s, st + "." + s);
                }
                registry.addCandidate(c);
                continue;
            }
            AutocompleteRegistryFactory.createImportAutocompleteCandidate(cu, registry, imp);
        }
    }

    public static void createImportAutocompleteCandidate(ClassUtils cu, AutocompleteRegistry registry, String imp) {
        String[] txtv = imp.split("\\.");
        AutocompleteCandidate c = new AutocompleteCandidate(0, txtv, txtv.length - 1);
        registry.addCandidate(c);
        c = new AutocompleteCandidate(5, txtv);
        registry.addCandidate(c);
        c = new AutocompleteCandidate(6, txtv[txtv.length - 1]);
        registry.addCandidate(c);
        cu.defineClassShortName(txtv[txtv.length - 1], imp);
    }

    public static void moreSetup(ClassUtils cu) {
        cu.defineVariable("beakerx", "com.twosigma.beakerx.NamespaceClient");
    }
}

