/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import org.assertj.core.util.diff.Chunk;
import org.assertj.core.util.diff.Delta;

public class ChangeDelta<T>
extends Delta<T> {
    public ChangeDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws IllegalStateException {
        int i;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void verify(List<T> target) throws IllegalStateException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new IllegalStateException("Incorrect patch for delta: delta original position > target size");
        }
    }

    public String toString() {
        return String.format("Changed content at line %s:%nexpecting:%n  %s%nbut was:%n  %s%n", this.lineNumber(), this.formatLines(this.getOriginal().getLines()), this.formatLines(this.getRevised().getLines()));
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

