/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.Foldout;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.Label;
import com.twosigma.beakerx.widget.SparkConfiguration;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkFoldout;
import com.twosigma.beakerx.widget.SparkStateProgress;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.SparkVariable;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkUI
extends VBox
implements SparkUIApi {
    public static final String SPARK_REPL_CLASS_OUTPUT_DIR = "spark.repl.class.outputDir";
    public static final String SPARK_APP_NAME = "spark.app.name";
    public static final String SPARK_MASTER = "spark.master";
    public static final String SPARK_EXECUTOR_MEMORY = "spark.executor.memory";
    public static final String SPARK_EXECUTOR_CORES = "spark.executor.cores";
    public static final String SPARK_EXTRA_LISTENERS = "spark.extraListeners";
    public static final String BEAKERX_ID = "beakerx.id";
    public static final List<String> STANDARD_SETTINGS = Arrays.asList("spark.master", "spark.executor.memory", "spark.executor.cores", "spark.app.name", "beakerx.id", "spark.extraListeners", "spark.repl.class.outputDir");
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    static final String SPARK_SESSION_NAME = "spark";
    static final String CONNECT = "Start";
    private static final String SPARK_MASTER_DEFAULT = "local[*]";
    public static final String SPARK_APP_ID = "sparkAppId";
    private VBox sparkConfig;
    private VBox sparkConfigPanel;
    private Button connectButton;
    private HBox statusPanel;
    private Map<Integer, SparkStateProgress> progressBarMap = new HashMap<Integer, SparkStateProgress>();
    private Text masterURL;
    private Text executorMemory;
    private Text executorCores;
    private SparkConfiguration advancedOption;
    private boolean active = false;
    private SparkFoldout jobPanel = null;
    private Message currentParentHeader = null;
    private SparkEngine sparkEngine;
    private SparkUiDefaults sparkUiDefaults;

    SparkUI(SparkSession.Builder builder, SparkEngine.SparkEngineFactory sparkEngineFactory, SparkUiDefaults sparkUiDefaults) {
        super(new ArrayList());
        this.sparkUiDefaults = sparkUiDefaults;
        this.sparkUiDefaults.loadDefaults(builder);
        this.sparkEngine = sparkEngineFactory.create(builder);
        this.sparkConfig = new VBox(new ArrayList());
        this.sparkConfigPanel = new VBox(Collections.singletonList(this.sparkConfig));
        this.add((Widget)this.sparkConfigPanel);
        SparkVariable.putSparkUI(this);
        this.createSparkView();
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    private void createSparkView() {
        this.masterURL = this.createMasterURL();
        this.executorMemory = this.createExecutorMemory();
        this.executorCores = this.createExecutorCores();
        this.addConnectButton(this.createConnectButton());
        this.addMasterUrl(this.masterURL);
        this.addExecutorCores(this.executorCores);
        this.addExecutorMemory(this.executorMemory);
        this.advancedOption = new SparkConfiguration(this.sparkEngine.getAdvanceSettings(), this.sparkEngine.sparkVersion());
        this.addAdvanceOptions(this.advancedOption);
        this.sendUpdate("sparkDefaultMasterUrl", SPARK_MASTER_DEFAULT);
    }

    private Text createExecutorCores() {
        Text cores = new Text();
        cores.setDescription((Object)"Executor cores");
        cores.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-cores")));
        if (this.getSparkConf().contains(SPARK_EXECUTOR_CORES)) {
            cores.setValue((Object)this.getSparkConf().get(SPARK_EXECUTOR_CORES));
        } else {
            cores.setValue((Object)"10");
        }
        return cores;
    }

    private SparkConf getSparkConf() {
        return this.sparkEngine.getSparkConf();
    }

    private Text createExecutorMemory() {
        Text memory = new Text();
        memory.setDescription((Object)"Executor Memory");
        memory.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-memory")));
        if (this.getSparkConf().contains(SPARK_EXECUTOR_MEMORY)) {
            memory.setValue((Object)this.getSparkConf().get(SPARK_EXECUTOR_MEMORY));
        } else {
            memory.setValue((Object)"8g");
        }
        return memory;
    }

    private Text createMasterURL() {
        Text masterURL = new Text();
        masterURL.setDescription((Object)"Master URL");
        masterURL.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-master-url")));
        if (this.getSparkConf().contains(SPARK_MASTER)) {
            masterURL.setValue((Object)this.getSparkConf().get(SPARK_MASTER));
        } else {
            masterURL.setValue((Object)SPARK_MASTER_DEFAULT);
        }
        return masterURL;
    }

    private Button createConnectButton() {
        Button connect = new Button();
        connect.setDescription((Object)CONNECT);
        connect.registerOnClick((content, message) -> this.initSparkContext(message));
        return connect;
    }

    private void initSparkContext(Message parentMessage) {
        KernelFunctionality kernel = KernelManager.get();
        try {
            TryResult configure = this.sparkEngine.configure(kernel, this, parentMessage);
            if (configure.isError()) {
                this.sendError(parentMessage, kernel, configure.error());
            } else {
                this.active = true;
                this.saveSparkConf(this.sparkEngine.getSparkConf());
            }
        }
        catch (Exception e) {
            this.sendError(parentMessage, kernel, e.getMessage());
        }
    }

    private SparkSession getSparkSession() {
        return this.sparkEngine.getOrCreate();
    }

    private void sendError(Message parentMessage, KernelFunctionality kernel, String message) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)"", (KernelFunctionality)kernel, (Message)parentMessage, (int)1);
        seo.error((Object)message);
    }

    @Override
    public void applicationStart() {
        this.clearView();
        this.addStatusPanel(this.createStatusPanel());
        this.sendUpdate(SPARK_APP_ID, this.sparkEngine.getSparkAppId());
        this.sendUpdate("sparkUiWebUrl", this.sparkEngine.getSparkUiWebUrl());
        this.sendUpdate("sparkMasterUrl", this.sparkEngine.getSparkMasterUrl());
    }

    @Override
    public void applicationEnd() {
        this.removeStatusPanel();
        this.active = false;
        this.addView();
    }

    private HBox createStatusPanel() {
        Label appStatus = this.createAppStatus();
        Button disconnect = this.createDisconnectButton();
        HBox connectionPanel = new HBox(Arrays.asList(appStatus, disconnect));
        connectionPanel.setDomClasses(new ArrayList<String>(Arrays.asList("bx-status-panel")));
        return connectionPanel;
    }

    private Label createAppStatus() {
        Label appStatus = new Label();
        appStatus.setValue((Object)"Connected");
        appStatus.setDomClasses(new ArrayList<String>(Arrays.asList("bx-connection-status", "connected")));
        return appStatus;
    }

    private Button createDisconnectButton() {
        Button disconnect = new Button();
        disconnect.registerOnClick((content, message) -> this.getSparkSession().sparkContext().stop());
        disconnect.setTooltip("Stop Spark Session");
        disconnect.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        return disconnect;
    }

    @Override
    public void startStage(int stageId, int numTasks) {
        if (this.isStartStageFromNewCell()) {
            this.jobPanel = this.createSparkFoldout(this.jobPanel);
        }
        SparkStateProgress intProgress = new SparkStateProgress(numTasks, stageId, stageId, this.jobLink(stageId), this.stageLink(stageId));
        intProgress.init();
        this.jobPanel.add((Widget)intProgress);
        this.progressBarMap.put(stageId, intProgress);
    }

    private boolean isStartStageFromNewCell() {
        return InternalVariable.getParentHeader() != this.currentParentHeader;
    }

    private SparkFoldout createSparkFoldout(SparkFoldout oldJobPanel) {
        this.currentParentHeader = InternalVariable.getParentHeader();
        if (oldJobPanel != null) {
            oldJobPanel.getLayout().setDisplayNone();
            oldJobPanel.close();
        }
        Foldout.FoldoutOption foldoutOption = new Foldout.FoldoutOption();
        foldoutOption.headerLabel = "Spark progress";
        SparkFoldout jobPanel = new SparkFoldout(new ArrayList(), foldoutOption);
        jobPanel.display();
        return jobPanel;
    }

    @Override
    public void endStage(int stageId) {
        SparkStateProgress sparkStateProgress = this.progressBarMap.get(stageId);
        sparkStateProgress.hide();
    }

    @Override
    public void taskStart(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBarMap.get(stageId);
        intProgress.addActive();
    }

    @Override
    public void taskEnd(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBarMap.get(stageId);
        intProgress.addDone();
    }

    private String stageLink(int stageId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
        }
        return "";
    }

    private String jobLink(int jobId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
        }
        return "";
    }

    @Override
    public void cancelAllJobs() {
        this.getSparkSession().sparkContext().cancelAllJobs();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Text getMasterURL() {
        return this.masterURL;
    }

    @Override
    public Text getExecutorMemory() {
        return this.executorMemory;
    }

    @Override
    public Text getExecutorCores() {
        return this.executorCores;
    }

    @Override
    public List<SparkConfiguration.Configuration> getAdvancedOptions() {
        return this.advancedOption.getConfiguration();
    }

    public void addMasterUrl(Text masterURL) {
        this.sparkConfig.add((Widget)masterURL);
    }

    public void addExecutorCores(Text executorCores) {
        this.sparkConfig.add((Widget)executorCores);
    }

    public void addExecutorMemory(Text executorMemory) {
        this.sparkConfig.add((Widget)executorMemory);
    }

    public void addConnectButton(Button connect) {
        this.connectButton = connect;
        this.sparkConfig.add((Widget)this.connectButton);
    }

    public void clearView() {
        this.remove((Widget)this.sparkConfigPanel);
        this.sparkConfigPanel = null;
    }

    public void addView() {
        this.sparkConfigPanel = new VBox(Arrays.asList(this.sparkConfig));
        this.add((Widget)this.sparkConfigPanel);
    }

    public Button getConnectButton() {
        return this.connectButton;
    }

    public void addAdvanceOptions(SparkConfiguration advancedOption) {
        this.sparkConfig.add((Widget)advancedOption);
    }

    public void addStatusPanel(HBox statusPanel) {
        this.statusPanel = statusPanel;
        this.add((Widget)statusPanel);
    }

    public void removeStatusPanel() {
        if (this.statusPanel != null) {
            this.removeDOMWidget((DOMWidget)this.statusPanel);
            this.statusPanel = null;
        }
    }

    void saveSparkConf(SparkConf sparkConf) {
        this.sparkUiDefaults.saveSparkConf(sparkConf);
    }

    public static class SparkUIFactoryImpl
    implements SparkUIFactory {
        SparkEngine.SparkEngineFactory sparkEngineFactory;
        SparkUiDefaults sparkUiDefaults;

        public SparkUIFactoryImpl(SparkEngine.SparkEngineFactory sparkEngineFactory, SparkUiDefaults sparkUiDefaults) {
            this.sparkEngineFactory = sparkEngineFactory;
            this.sparkUiDefaults = sparkUiDefaults;
        }

        @Override
        public SparkUI create(SparkSession.Builder builder) {
            return new SparkUI(builder, this.sparkEngineFactory, this.sparkUiDefaults);
        }
    }

    public static interface SparkUIFactory {
        public SparkUI create(SparkSession.Builder var1);
    }
}

