/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.twosigma.beakerx.widget.SparkEngineImpl;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkUiDefaultsImpl
implements SparkUiDefaults {
    public static final String SPARK_OPTIONS = "spark_options";
    public static final String BEAKERX = "beakerx";
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Path path;

    public SparkUiDefaultsImpl(Path path) {
        this.path = path;
    }

    @Override
    public void saveSparkConf(SparkConf sparkConf) {
        Map<String, String> newSparkConf = this.getNewSparkConf(sparkConf);
        try {
            Map<String, Map> map = this.beakerxJson(this.path);
            map.get(BEAKERX).put(SPARK_OPTIONS, newSparkConf);
            String content = this.gson.toJson(map);
            Files.write(this.path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void loadDefaults(SparkSession.Builder builder) {
        SparkConf sparkConf = SparkEngineImpl.getSparkConfBasedOn(builder);
        try {
            Map<String, Map> beakerxJson = this.beakerxJson(this.path);
            Map map = (Map)beakerxJson.get(BEAKERX).get(SPARK_OPTIONS);
            if (map != null) {
                map.entrySet().stream().filter(x -> !sparkConf.contains((String)x.getKey())).forEach(x -> builder.config((String)x.getKey(), (String)x.getValue()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Map> beakerxJson(Path path) throws IOException {
        String pathToFile = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return this.toMap(pathToFile);
    }

    private Map<String, Map> toMap(String pathToFile) {
        return (Map)this.gson.fromJson(pathToFile, Map.class);
    }

    private Map<String, String> getNewSparkConf(SparkConf sparkConf) {
        HashMap<String, String> result = new HashMap<String, String>();
        Arrays.stream(sparkConf.getAll()).filter(x -> !((String)x._1).equals("spark.extraListeners")).filter(x -> !((String)x._1).equals("beakerx.id")).filter(x -> !((String)x._1).equals("spark.app.name")).forEach(x -> {
            String cfr_ignored_0 = (String)result.put((String)x._1, (String)x._2);
        });
        return result;
    }
}

