/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.Graphics;
import com.twosigma.beakerx.util.SerializerUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GraphicsSerializer<T extends Graphics>
extends JsonSerializer<T> {
    public static final String TYPE = "type";

    public void serialize(T graphics, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        Object[] keys;
        Map<String, String> keyTags;
        jgen.writeObjectField(TYPE, (Object)SerializerUtil.getTypeName(graphics));
        jgen.writeObjectField("uid", (Object)((Graphics)graphics).getUid());
        jgen.writeObjectField("visible", (Object)((Graphics)graphics).getVisible());
        jgen.writeObjectField("yAxis", (Object)((Graphics)graphics).getYAxis());
        jgen.writeObjectField("hasClickAction", (Object)((Graphics)graphics).hasClickAction());
        if (StringUtils.isNotEmpty((CharSequence)((Graphics)graphics).getClickTag())) {
            jgen.writeObjectField("clickTag", (Object)((Graphics)graphics).getClickTag());
        }
        if ((keyTags = ((Graphics)graphics).getKeyTags()) != null && !keyTags.isEmpty()) {
            jgen.writeObjectField("keyTags", keyTags);
        }
        if (ArrayUtils.isNotEmpty((Object[])(keys = ((Graphics)graphics).getKeys()))) {
            jgen.writeObjectField("keys", (Object)keys);
        }
    }
}

