/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.SparkManager;
import com.twosigma.beakerx.widget.SparkManagerImpl;
import com.twosigma.beakerx.widget.SparkUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkMagicCommand
implements MagicCommandFunctionality {
    public static final String SPARK = "%%sparkRunner";
    private KernelFunctionality kernel;
    private SparkUI.SparkUIFactory sparkUIFactory;
    private SparkManager.SparkManagerFactory sparkManagerFactory;
    private SparkUI sparkUI;
    private Map<String, SparkOption> sparkOptions;

    public SparkMagicCommand(KernelFunctionality kernel) {
        this(kernel, new SparkUI.SparkUIFactoryImpl(), new SparkManagerImpl.SparkManagerFactoryImpl());
    }

    SparkMagicCommand(KernelFunctionality kernel, SparkUI.SparkUIFactory sparkUIFactory, SparkManager.SparkManagerFactory sparkManagerFactory) {
        this.kernel = kernel;
        this.sparkUIFactory = sparkUIFactory;
        this.sparkManagerFactory = sparkManagerFactory;
        this.configureOptions();
    }

    private void configureOptions() {
        this.sparkOptions = new HashMap<String, SparkOption>();
        this.sparkOptions.put("--connect", this::connectToSparkSession);
        this.sparkOptions.put("-c", this::connectToSparkSession);
    }

    public String getMagicCommandName() {
        return SPARK;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        if (this.sparkUI != null && this.sparkUI.isSparkSessionIsActive()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Active spark session exists. If you want to close it run 'spark.close()'");
        }
        List<String> options = this.getOptions(param);
        MagicCommandOutcomeItem optionValidation = this.validateOptions(options);
        if (optionValidation.getStatus().equals((Object)MagicCommandOutcomeItem.Status.ERROR)) {
            return optionValidation;
        }
        MagicCommandOutcomeItem ui = this.createUI(param);
        if (ui.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            options.forEach(option -> this.sparkOptions.get(option).run(param.getCode().getMessage()));
        }
        return ui;
    }

    private MagicCommandOutcomeItem validateOptions(List<String> options) {
        for (String option : options) {
            if (this.sparkOptions.containsKey(option)) continue;
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Unknown option " + option);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private List<String> getOptions(MagicCommandExecutionParam param) {
        String[] parts = param.getCommand().split(" ");
        if (parts.length == 1) {
            return new ArrayList<String>();
        }
        return Arrays.asList(Arrays.copyOfRange(parts, 1, parts.length));
    }

    private MagicCommandOutcomeItem createUI(MagicCommandExecutionParam param) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)param.getCommandCodeBlock(), (KernelFunctionality)this.kernel, (Message)param.getCode().getMessage(), (int)param.getExecutionCount());
        if (param.getCommandCodeBlock().isEmpty()) {
            InternalVariable.setValue((SimpleEvaluationObject)seo);
            return this.createSparkUI(new SparkConf());
        }
        return this.createSparkUIBasedOnUserSparkConfiguration(param, seo);
    }

    private MagicCommandOutcomeItem createSparkUIBasedOnUserSparkConfiguration(MagicCommandExecutionParam param, SimpleEvaluationObject seo) {
        TryResult either = this.kernel.executeCode(param.getCommandCodeBlock(), seo);
        if (either.isResult()) {
            Object result = either.result();
            if (result instanceof SparkConf) {
                return this.createSparkUI((SparkConf)result);
            }
            if (result instanceof SparkSession.Builder) {
                return this.createSparkUI((SparkSession.Builder)result);
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Body of  %%sparkRunner magic command must return SparkConf object or SparkSession.Builder object");
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %%sparkRunner : " + either.error());
    }

    private MagicCommandOutcomeItem createSparkUI(SparkSession.Builder builder) {
        SparkManager sparkManager = this.sparkManagerFactory.create(builder);
        this.sparkUI = this.sparkUIFactory.create(sparkManager);
        return this.displaySparkUI(this.sparkUI);
    }

    private MagicCommandOutcomeItem createSparkUI(SparkConf sparkConf) {
        SparkSession.Builder builder = SparkSession.builder().config(sparkConf);
        SparkManager sparkManager = this.sparkManagerFactory.create(builder);
        this.sparkUI = this.sparkUIFactory.create(sparkManager);
        return this.displaySparkUI(this.sparkUI);
    }

    private MagicCommandOutcomeItem displaySparkUI(SparkUI sparkUI) {
        Display.display((Object)((Object)sparkUI));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private void connectToSparkSession(Message parent) {
        this.sparkUI.getConnectButton().onClick(new HashMap(), new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())));
    }

    static interface SparkOption {
        public void run(Message var1);
    }
}

