/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.HTML;
import com.twosigma.beakerx.widget.Label;
import com.twosigma.beakerx.widget.SparkFoldout;
import com.twosigma.beakerx.widget.SparkManager;
import com.twosigma.beakerx.widget.SparkStateProgress;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkVariable;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.SparkSession;

public class SparkUIManager {
    public static final String SPARK_MASTER = "spark.master";
    public static final String SPARK_EXECUTOR_MEMORY = "spark.executor.memory";
    public static final String SPARK_EXECUTOR_CORES = "spark.executor.cores";
    public static final String SPARK_SESSION_NAME = "spark";
    public static final String CONNECT = "Connect";
    private static final String SPARK_MASTER_DEFAULT = "local[*]";
    private final SparkUI sparkUI;
    private Map<Integer, SparkStateProgress> progressBars = new HashMap<Integer, SparkStateProgress>();
    private HBox statusPanel;
    private Text masterURL;
    private Text executorMemory;
    private Text executorCores;
    private boolean active = false;
    private SparkManager sparkManager;
    private SparkFoldout jobPanel = null;

    public SparkUIManager(SparkUI sparkUI, SparkManager sparkManager) {
        this.sparkUI = sparkUI;
        this.sparkManager = sparkManager;
        SparkVariable.putSparkUIManager(this);
        this.createSparkView();
    }

    private void createSparkView() {
        this.masterURL = this.createMasterURL();
        this.executorMemory = this.createExecutorMemory();
        this.executorCores = this.createExecutorCores();
        this.sparkUI.addMasterUrl(this.masterURL);
        this.sparkUI.addExecutorCores(this.executorCores);
        this.sparkUI.addExecutorMemory(this.executorMemory);
        this.sparkUI.addConnectButton(this.createConnectButton());
    }

    private Text createExecutorCores() {
        Text cores = new Text();
        cores.setDescription((Object)"Executor cores");
        if (this.sparkManager.getSparkConf().contains(SPARK_EXECUTOR_CORES)) {
            cores.setValue((Object)this.sparkManager.getSparkConf().get(SPARK_EXECUTOR_CORES));
        } else {
            cores.setValue((Object)"10");
        }
        return cores;
    }

    private Text createExecutorMemory() {
        Text masterURL = new Text();
        masterURL.setDescription((Object)"Executor Memory");
        if (this.sparkManager.getSparkConf().contains(SPARK_EXECUTOR_MEMORY)) {
            masterURL.setValue((Object)this.sparkManager.getSparkConf().get(SPARK_EXECUTOR_MEMORY));
        } else {
            masterURL.setValue((Object)"8g");
        }
        return masterURL;
    }

    private Text createMasterURL() {
        Text masterURL = new Text();
        masterURL.setDescription((Object)"Master URL");
        if (this.sparkManager.getSparkConf().contains(SPARK_MASTER)) {
            masterURL.setValue((Object)this.sparkManager.getSparkConf().get(SPARK_MASTER));
        } else {
            masterURL.setValue((Object)SPARK_MASTER_DEFAULT);
        }
        return masterURL;
    }

    private Button createConnectButton() {
        Button connect = new Button();
        connect.setDescription((Object)CONNECT);
        connect.registerOnClick((content, message) -> this.initSparkContext(message));
        return connect;
    }

    private void initSparkContext(Message parentMessage) {
        KernelFunctionality kernel = KernelManager.get();
        try {
            TryResult configure = this.sparkManager.configure(kernel, this, parentMessage);
            if (configure.isError()) {
                this.sendError(parentMessage, kernel, configure.error());
            } else {
                this.active = true;
            }
        }
        catch (Exception e) {
            this.sendError(parentMessage, kernel, e.getMessage());
        }
    }

    private SparkSession getSparkSession() {
        return this.sparkManager.getOrCreate();
    }

    private void sendError(Message parentMessage, KernelFunctionality kernel, String message) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)"", (KernelFunctionality)kernel, (Message)parentMessage, (int)1);
        seo.error((Object)message);
    }

    public void applicationStart() {
        this.sparkUI.clearView();
        this.statusPanel = this.createStatusPanel();
    }

    public void applicationEnd() {
        if (this.statusPanel != null) {
            this.sparkUI.removeDOMWidget((DOMWidget)this.statusPanel);
            this.statusPanel = null;
            this.active = false;
            this.createSparkView();
        }
    }

    private HBox createStatusPanel() {
        Label appStatus = this.createAppStatus();
        Button disconnect = this.createDisconnectButton();
        HBox statusPanel = new HBox(Arrays.asList(this.uiLink(), disconnect, appStatus));
        this.sparkUI.add((Widget)statusPanel);
        return statusPanel;
    }

    private Label createAppStatus() {
        Label appStatus = new Label();
        appStatus.setValue((Object)("Connected to " + this.sparkManager.getSparkConf().get(SPARK_MASTER)));
        return appStatus;
    }

    private Button createDisconnectButton() {
        Button disconnect = new Button();
        disconnect.registerOnClick((content, message) -> this.getSparkSession().sparkContext().stop());
        disconnect.setDescription((Object)"Disconnect");
        return disconnect;
    }

    void startStage(int stageId, int numTasks) {
        SparkStateProgress intProgress = new SparkStateProgress(numTasks, stageId, stageId, this.jobLink(stageId), this.stageLink(stageId));
        intProgress.init();
        if (this.jobPanel != null) {
            this.jobPanel.getLayout().setDisplayNone();
            this.jobPanel.close();
        }
        Label label = new Label();
        label.setValue((Object)"Spark progress");
        this.jobPanel = new SparkFoldout();
        this.jobPanel.add((Widget)label);
        this.jobPanel.add((Widget)intProgress);
        this.jobPanel.display();
        this.progressBars.put(stageId, intProgress);
    }

    void endStage(int stageId) {
        SparkStateProgress sparkStateProgress = this.progressBars.get(stageId);
        sparkStateProgress.hide();
    }

    void taskStart(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBars.get(stageId);
        intProgress.addActive();
    }

    void taskEnd(int stageId, long taskId) {
        SparkStateProgress intProgress = this.progressBars.get(stageId);
        intProgress.addDone();
    }

    private HTML uiLink() {
        if (this.sparkManager.sparkContext().uiWebUrl().isDefined()) {
            HTML html = new HTML();
            html.setValue((Object)("<a target=\"_blank\" href=\"" + (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "\">Spark UI</a>"));
            return html;
        }
        HTML html = new HTML();
        html.setValue((Object)"<a target=\"_blank\" href=\"\">Spark UI </a>");
        return html;
    }

    private String stageLink(int stageId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
        }
        return "";
    }

    private String jobLink(int jobId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
        }
        return "";
    }

    public void cancelAllJobs() {
        this.getSparkSession().sparkContext().cancelAllJobs();
    }

    public boolean isActive() {
        return this.active;
    }

    public Text getMasterURL() {
        return this.masterURL;
    }

    public Text getExecutorMemory() {
        return this.executorMemory;
    }

    public Text getExecutorCores() {
        return this.executorCores;
    }
}

